<%@ include file="../shared/inc_header.jsp"%>

<%-- Example to hide search filter, if they want that elsewhere - CPB
	<jsp:param name="dom" value='<"top"i>rt<"bottom"pl><"clear">' />
	--%>
<jsp:include page="/WEB-INF/jsp/shared/inc_jqueryTable.jsp">
	<jsp:param name="dataTableId" value="excludedEntityList" />
</jsp:include>

<script type="text/javascript">
	$(function() {
		setPageTitleText("Excluded Entity Matches for <c:out value="${facilityContextName}" />")
	
		<sec:authorize
			access="hasAnyAuthority('${PERMISSION_EXCLUDED_ENTITY_VIEW_ALL}')">
			setPageTitleText('Excluded Entity Matches for All Facilities')
		</sec:authorize>
	})
</script>

<style>
@media print {
	#printButton, #viewAllButton {
		display:none;
	}
}
</style>

<div style="float:right;margin-right:15px" id="viewAllButton">
	<a href="${home}/excludedEntityViewAll.htm">View all LEIE data</a> <a href="${home}/excludedEntityList.htm"><img
		alt="View All LEIE Data" src="${imgHome}/right.gif" border="0" align="absmiddle" /></a>
</div>

<div class="clearCenter" style="border: 1px gray;text-align:center">
	LEIE source data last updated: <b><vss:localDate
			date="${lastUpdatedDate}" pattern="${DATE_ONLY}" /></b><br>
	LEIE process last executed: <b><vss:localDate
			date="${lastExecutedDate}" pattern="${DATE_ONLY}" /></b>
</div>
<p />
<c:if test="${not empty excludedEntities}">
	<table summary="Format table" align="center" width="97%">
		<tr>
			<td align="center">
				<table id="excludedEntityList" class="stripe"
					summary="List of Excluded Entities" width="100%">
					<thead>
						<tr id="excludedEntitySearchFilterRow">
							<td class="noborder">Filters:</td>
							<td class="noborder" title="Filter by Facility"></td>
							<td class="noborder"></td>
							<td class="noborder" title="Filter by SSA"></td>
							<td class="noborder" title="Filter by 42USC code"></td>
							<td class="noborder"></td>
							<td class="noborder"></td>
							<td class="noborder"></td>
							<td class="noborder"></td>
							<td class="noborder"></td>
							<td class="noborder"></td>
						</tr>
						<tr>
							<th>Volunteer</th>
							<th class="select-filter">Facility</th>
							<th>LEIE Name</th>
							<th class="select-filter">SSA</th>
							<th class="select-filter">42 USC Code</th>
							<th>Exclusion Date</th>
							<th>Description</th>
							<th>VSS Address</th>
							<th>LEIE Address</th>
							<th>VSS Date of Birth</th>
							<th>LEIE Date of Birth</th>
						</tr>
					</thead>

					<c:forEach var="eeMatch" items="${excludedEntities}">
						<c:set var="v" value="${eeMatch.volunteer}" />
						<c:set var="ee" value="${eeMatch.excludedEntity}" />

						<tr>
							<td><a class="appLink" href="${home}/volunteerEdit.htm?id=${v.id}"><c:out value="${v.displayName}" /></a></td>
							<td><c:out value="${v.primaryFacility.displayName}" /></td>
							<td><c:out value="${ee.displayName}" /></td>
							<td><c:out value="${ee.exclusionType.ssa}" /></td>
							<td><c:out value="${ee.exclusionType.code42Usc}" /></td>
							<td><vss:localDate date="${ee.exclusionDate}"
									pattern="${DATE_ONLY}" /></td>
							<td><c:out value="${ee.exclusionType.description}" /></td>
							<td><pre>
									<c:out value="${v.addressMultilineDisplay}" />
								</pre></td>
							<td><pre>
									<c:out value="${ee.addressMultilineDisplay}" />
								</pre></td>
							<td><vss:localDate date="${v.dateOfBirth}"
									pattern="${DATE_ONLY}" /></td>
							<td><vss:localDate date="${ee.dob}" pattern="${DATE_ONLY}" /></td>
						</tr>
					</c:forEach>
				</table>
			</td>
		</tr>
	</table>
</c:if>
<c:if test="${empty excludedEntities}">
	<c:set var="canViewAll" value="false" />
	<sec:authorize
		access="hasAnyAuthority('${PERMISSION_EXCLUDED_ENTITY_VIEW_ALL}')">
		<c:set var="canViewAll" value="true" />
	</sec:authorize>
	<div align="center" id="printButton"><a class="buttonAnchor" href="javascript:print()">Print</a></div>
	<table align="center" cellpadding="10">
		<tr>
			<td>No excluded entities were found <c:if test="${canViewAll}">
					at any facility.
				 </c:if> <c:if test="${not canViewAll}">
				for facility "<c:out value="${facilityContextName}" />".
				</c:if>
			</td>
		</tr>
	</table>
</c:if>