<%@ include file="../shared/inc_header.jsp"%>

<script type="text/javascript">
	var isReadOnly = <c:out value="${FORM_READ_ONLY}" />
	var awardProcessedType = <c:out value="${awardCommand.awardsProcessed}" />

	$(function() {
		$('.dateInput').each(function() {
			$(this).enableDatePicker({
				showOn : "button",
				buttonImage : imgHomePath + "/calendar.gif",
				buttonImageOnly : true
			})
			$(this).mask(twoDigitDateMask)
		})

		var theDataTable = $('#eligibleAwardResultsList').DataTable({
			buttons : [ {
				extend : 'excel',
				exportOptions : {
					columns : '.exportCol'
				}
			}, {
				extend : 'pdfHtml5',
				orientation : 'landscape',
				exportOptions : {
					columns : '.exportCol'
				}
			}, {
				extend : 'print',
				exportOptions : {
					columns : '.exportCol'
				}
			} ],
			"dom" : '<"top"fBi>rt<"bottom"><"clear">',
			"order" : [],
			"paging" : false,			
			"columnDefs" : [{
				targets: isReadOnly ? [10] : [0, 11],
			     orderable: false
		    }] 
				
		})
		
		theDataTable = $('#processedAwardResultsList').DataTable({
			buttons : [ {
				extend : 'excel',
				exportOptions : {
					columns : '.exportCol'
				}
			}, {
				extend : 'pdfHtml5',
				orientation : 'landscape',
				exportOptions : {
					columns : '.exportCol'
				}
			}, {
				extend : 'print',
				exportOptions : {
					columns : '.exportCol'
				}
			} ],
			"dom" : '<"top"fBi>rt<"bottom"><"clear">',
			"order" : [],
			"paging" : false,			
			"columnDefs" : [{
				 targets:  [10],
			     orderable: false
		    }]
		})

		$('#awardDate').enableDatePicker({
			showOn : "button",
			buttonImage : imgHomePath + "/calendar.gif",
			buttonImageOnly : true
		})
		$('#awardDate').mask("${TWO_DIGIT_DATE_MASK}", {
			autoclear : false
		})

		rebuildTableFilters("processedAwardResultsList")
		rebuildTableFilters("eligibleAwardResultsList")

		toggleDisplays()

		$(".dispositionInput").change(function() {
			awardProcessedType = $(".dispositionInput:checked").val()
			$("#includeAdult").prop('checked', true)
			$("#includeYouth").prop('checked', true)
			$("#includeOther").prop('checked', true)
			$("#includeActive").prop('checked', true)
			$("#includeSeparated").prop('checked',false) 			
			hideDisplays()
		})
	})

	function hideDisplays() {
		$('.awardProcessed').toggle(false);
		$('.awardPotential').toggle(false);
		$('.awardProcessedField').toggle(awardProcessedType == 1);
		$('#beginDateInput').val('');
		$('#endDateInput').val('');
	}
	
	function toggleDisplays() {
		$('.awardProcessed').toggle(awardProcessedType == 1);
		$('.awardPotential').toggle(awardProcessedType == 0);
		$('.awardProcessedField').toggle(awardProcessedType == 1);
	}
	
	function getDisplayPrefix() {
		return $('.awardPotential').eq(0).is(':visible') ? 'potential' : 'processed'
	}

	function printSelected() {
		var volunteerIds = new Array()
		$("input[name='" + getDisplayPrefix() + "VolAwardSelect']:checked").each(function(index, item) {
			volunteerIds.push($(item).val())
		})
		if (volunteerIds.length == 0) {
			displayAttentionDialog('Please select at least one label to print.')
			return
		}
		
		if (volunteerIds.length > 990) {
			displayAttentionDialog('Please limit number of labels to print to 990 (33 pages worth of labels) at a time.')
			return
		}
		
		printIfNeeded(volunteerIds)
	}
	
	function printIfNeeded(volunteerIds) {
		var reportsToPrint = []
				
		var commonParams = {
			Username : "<c:out value="${username}" />",
			UserPasswordHash : "<c:out value="${userPasswordHash}" />",
			FacilityContextId : "<c:out value="${siteContextId}" />"
		}
		
		reportsToPrint.push({
				reportName : 'Volunteer_AddressLabels_By_Vol_Id',
				reportOutputFormat : 'PDF',
				reportParams : $.extend({}, commonParams, {
					VolId : volunteerIds
				})
			})
		
			
		if (reportsToPrint.length > 0)
			printReports(reportsToPrint)
	}

	function setAllCheckboxes(isChecked) {
		$("input[name='" + getDisplayPrefix() + "VolAwardSelect']").prop('checked', isChecked)
	}

	function validateSearchForm() {
		var errors = new Array()
		
		if (!$(".dispositionInput").is(":checked")) {
			 erros.push("Disposition is required.")
		}
		if (awardProcessedType == 1) {
			if ($('#beginDateInput').val() != '' && !validateDate($('#beginDateInput').val())) {
				errors.push("Begin Date is invalid.")
			}
			
			if ($('#endDateInput').val() != '' && !validateDate($('#endDateInput').val())) {
				errors.push("End Date is invalid.")
			}
			
			if ($('#beginDateInput').val() != '' &&  $('#endDateInput').val() != '')  {
				var beginDate = getDateFromMMDDYYYY($('#beginDateInput').val())
				var endDate = getDateFromMMDDYYYY($('#endDateInput').val())
		        if (endDate < beginDate)	
		        	errors.push("End Date must be after Begin Date.")
			}
        	
		}
		
		if (errors.length > 0) {
			displayAttentionDialog("Please correct the following errors: <ul><li>"
					+ errors.join("</li><li>") + "</li></ul>");
		}
		
		return errors.length == 0
	}
	
	function validatePostForm() {
		var errors = new Array()
			
		if ($('#awardDate').val() != ''
				&& !validateDate($('#awardDate').val())) {
			errors.push("Award Date is invalid.")
		}
		
		if ($('#awardDate').val() == '')
			errors.push("Award Date is required.")
			
		var checkedVols = $('.awardVolunteerId:checked')
		if (checkedVols.length == 0 )
			errors.push("Please select at least 1 volunteer to receive award.")
		
		if (errors.length > 0) {
			displayAttentionDialog("Please correct the following errors: <ul><li>"
					+ errors.join("</li><li>") + "</li></ul>")
			return false
		}
		
		msg = '<span  class="redText">WARNING: This process will code the awards for the selected volunteers.' +
			' The process may take some time to post the awards and is an irreversible process.  Do you want to continue?</span>'
		confirmDialog(msg, function() {
			$('.awardVolunteerId:checked').each(function(index, item) {
				$("#awardForVolId" + $(item).attr('value')).prop('disabled', false)
			})
			
			$("#awardResultForm")[0].submit()
		 })
		 
		return false
	}
</script>

<style>
div.awardSearchFields {
	min-width: 480px;
	max-width: 1000px;
}
</style>

<form:form method="post" modelAttribute="awardCommand"
	action="${home}/awardSearchSubmit.htm" id="awardSearchForm"
	onsubmit="return validateSearchForm();">
	<div class="clearCenter awardSearchFields">
		<table align="center">
			<tr class="clearCenter">
				<td class='appFieldLabel' nowrap><label tabindex="0"
					for="dispositionInputs">Disposition:</label><span
					class="invisibleRequiredFor508">*</span></td>
				<td style="text-align: left"><span class='requdIndic ator'>*</span></td>
				<td><fieldset id="dispositionInputs" class="inputFieldset">
						<legend>Disposition</legend>
						<label><form:radiobutton path="awardsProcessed" value="0"
								class="dispositionInput" tabindex="0" />Eligible</label><span
							style="padding-left: 18px"><label><form:radiobutton
									path="awardsProcessed" value="1" class="dispositionInput"
									tabindex="0" />Processed</label></span>
					</fieldset></td>
			</tr>

			<tr class="clearCenter">
				<td class='appFieldLabel' nowrap><label tabindex="0"
					for="awardTypeInputs">Type:</label></td>
				<td></td>
				<td><fieldset id="awardTypeInputs" class="inputFieldset">
						<legend>Type</legend>
						<label><form:checkbox path="includeAdult"
								id="includeAdult" />Adult</label> <span style="padding-left: 25px"><label><form:checkbox
									path="includeYouth" id="includeYouth" />Youth</label></span> <span
							class="awardProcessedField"
							style="display: none; padding-left: 20px"><label>
								<form:checkbox path="includeOther" id="includeOther" />Other
						</label></span>
					</fieldset></td>
			</tr>
			<tr class="clearCenter">
				<td class='appFieldLabel' nowrap><label tabindex="0"
					for="awardStatusInputs">Status:</label></td>
				<td></td>
				<td><fieldset id="awardStatusInputs" class="inputFieldset">
						<legend>Status</legend>
						<label><form:checkbox path="includeActive"
								id="includeActive" />Active</label> <span style="padding-left: 20px"><label><form:checkbox
									path="includeSeparated" id="includeSeparated" />Separated</label></span>
					</fieldset></td>
			</tr>
			<tr class="awardProcessedField" style="display: none">
				<td align="right"><label for="beginDateInput">Begin
						Date:</label></td>
				<td></td>
				<td><app:input size="12" id="beginDateInput" path="startDate"
						cssClass="dateInput" /><br> <app:errors path="startDate"
						cssClass="msg-error" /></td>
			</tr>
			<tr class="awardProcessedField" style="display: none">
				<td align="right"><label for="endDateInput">End Date:</label></td>
				<td></td>
				<td><app:input size="12" id="endDateInput" path="endDate"
						cssClass="dateInput" /><br> <app:errors path="endDate"
						cssClass="msg-error" /></td>
			</tr>
		</table>

		<div class="clearCenter" style="padding-top: 15px">
			<input id="submitButton" type="submit" value="Search" /> <span
				style="padding-left: 20px"><a id="cancelOperationBtn"
				class="buttonAnchor" href="${current_breadcrumb}">Cancel</a></span>
		</div>
	</div>

</form:form>

<form method="post" action="${home}/awardPostSubmit.htm"
	id="awardResultForm" onsubmit="return validatePostForm();">
	<c:if test="${not empty awardCommand.eligibleAwardResults }">
		<div class="clearCenter awardPotential" style="display: none">
			<table summary="Format table" align="center" width="100%">
				<tr>
					<td align="center">
						<table id="eligibleAwardResultsList" class="stripe"
							summary="List of Award">
							<thead>
								<tr>
									<c:if test="${not FORM_READ_ONLY}">
										<td class="noborder"></td>
									</c:if>
									<td class="noborder" title="Filter by Award Name"></td>
									<td class="noborder" title="Filter by Type"></td>
									<td class="noborder"></td>
									<td class="noborder" title="Filter by Status"></td>
									<td class="noborder" style="display: none"></td>
									<td class="noborder" id="initiatorFilter"
										title="Filter Awards by last award date"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder" style="display: none"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
								</tr>
								<tr>
									<c:if test="${not FORM_READ_ONLY}">
										<th>Give Award</th>
									</c:if>
									<th class="select-filter exportCol">Award Name</th>
									<th class="select-filter exportCol">Type</th>
									<th class="exportCol">Volunteer Name</th>
									<th class="select-filter exportCol">Status</th>
									<th class="exportCol" style="display: none">Last Award
										Date</th>
									<th>Last Award Date</th>
									<th class="exportCol">Last Award Hours</th>
									<th class="exportCol">Svc Yrs</th>
									<th class="exportCol">Total Hours</th>
									<th class="exportCol">Avg Hours/Mo</th>
									<th class="exportCol" style="display: none">Date Last
										Volunteered</th>
									<th>Date Last Volunteered</th>
									<th align="center" nowrap class="tableHeaderLinkWrapper">Labels<br>
										<a class="tableHeaderLink"
										href="javascript:setAllCheckboxes(true)">All</a> / <a
										class="tableHeaderLink"
										href="javascript:setAllCheckboxes(false)">None</a></th>
								</tr>
							</thead>
							<tbody>
								<c:forEach var="awardResult"
									items="${awardCommand.eligibleAwardResults}">
									<c:set var="vol"
										value="${awardCommand.volunteersMap[awardResult.volunteerId]}" />
									<tr>
										<c:set var="checked" value="checked='checked'" />

										<c:if test="${vol.status.volunteerInactiveOrTerminated}">
											<c:set var="checked" value="" />
										</c:if>
										<c:if test="${not FORM_READ_ONLY}">
											<td><input type="checkbox" class="awardVolunteerId"
												name="awardVolunteerIds" value="${awardResult.volunteerId}"
												${checked} /> <input type="hidden"
												id="awardForVolId${awardResult.volunteerId}"
												name="awardForVolId${awardResult.volunteerId}"
												value="${awardResult.deservedAwardId}" disabled="disabled" /></td>
										</c:if>
										<td><c:out value="${awardResult.deservedAwardName}" /></td>
										<td><c:out value="${awardResult.awardType}" /></td>
										<td align="left"><a
											href="${home}/volunteerEdit.htm?id=${awardResult.volunteerId}"><c:out
													value="${vol.displayName}" /></a></td>
										<td><c:out value="${awardResult.volStatus}" /></td>
										<td align="right" style="display: none"><vss:localDate
												date="${awardResult.dateLastAward}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><span style="display: none"><vss:localDate
													date="${awardResult.dateLastAward}" pattern="${MSD_TO_LSD}" /></span>
											<vss:localDate date="${awardResult.dateLastAward}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><c:out
												value="${awardResult.hoursLastAward}" /></td>
										<td align="right"><c:out
												value="${awardResult.yearsWorked}" /></td>
										<td align="right"><c:out
												value="${awardResult.actualHours}" /></td>
										<td align="right"><c:out value="${awardResult.aveHours}" /></td>
										<td align="right" style="display: none"><vss:localDate
												date="${awardResult.dateLastVolunteered}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><span style="display: none"><vss:localDate
													date="${awardResult.dateLastVolunteered}"
													pattern="${MSD_TO_LSD}" /></span> <vss:localDate
												date="${awardResult.dateLastVolunteered}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="center"><input type="checkbox"
											name="potentialVolAwardSelect" value="${vol.id}" /></td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					</td>
				</tr>
			</table>
			<div>
				<c:if test="${not FORM_READ_ONLY}">
					<table align="center" cellpadding="10">
						<tr class="awardPotential" style="display: none">
							<td class='appFieldLabel' nowrap>Award Date:<span
								class="invisibleRequiredFor508">*</span></td>
							<td style="text-align: left"><span class='requdIndicator'>*</span></td>
							<td><input size="15" id="awardDate" name="awardDate"
								value="${todayDate}" /></td>
						</tr>
					</table>
				</c:if>
				<div align="center" style="margin-top: 10px; margin-left: 15px">
					<c:if test="${not FORM_READ_ONLY}">
						<input id="submitButton" class="submitAnchor awardPotential"
							style="display: none" type="submit" value="Post Awards" />
					</c:if>
					<span style="padding-left: 20px"><a id="cancelPostAwardsBtn"
						class="buttonAnchor" href="${current_breadcrumb}">Cancel</a></span>
				</div>
				<div align="right" style="margin-top: -30px; margin-right: 15px">
					<a id="printSelectedButton" class="buttonAnchor"
						href="javascript:printSelected()">Print Labels</a>
				</div>
			</div>
		</div>
	</c:if>

	<c:if
		test="${awardCommand.awardsProcessed == 0 && empty awardCommand.eligibleAwardResults && awardCommand.eligibleSearched}">
		<table align="center" cellpadding="10">
			<tr>
				<td>Sorry, no awards were found that matched the specified
					criteria.</td>
			</tr>
		</table>
	</c:if>

	<!-- For Processed Awards List -->
	<c:if test="${not empty awardCommand.processedAwardResults}">
		<div class="clearCenter awardProcessed" style="display: none">
			<table summary="Format table" align="center" width="100%">
				<tr>
					<td align="center">
						<table id="processedAwardResultsList" class="stripe"
							summary="List of Award">
							<thead>
								<tr>
									<td class="noborder" title="Filter by Award Name"></td>
									<td class="noborder" title="Filter by Type"></td>
									<td class="noborder"></td>
									<td class="noborder" title="Filter by Status"></td>
									<td class="noborder" id="initiatorFilter"
										title="Filter Awards by last award date"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
									<td class="noborder"></td>
								</tr>
								<tr>
									<th class="select-filter exportCol">Award Name</th>
									<th class="select-filter exportCol">Type</th>
									<th class="exportCol">Volunteer Name</th>
									<th class="select-filter exportCol">Status</th>
									<th class="exportCol" style="display: none">Last Award
										Date</th>
									<th>Last Award Date</th>
									<th class="exportCol">Last Award Hours</th>
									<th class="exportCol">Svc Yrs</th>
									<th class="exportCol">Total Hours</th>
									<th class="exportCol">Avg Hours/Mo</th>
									<th class="exportCol" style="display: none">Date Last
										Volunteered</th>
									<th>Date Last Volunteered</th>
									<th align="center" nowrap class="tableHeaderLinkWrapper">Labels<br>
										<a class="tableHeaderLink"
										href="javascript:setAllCheckboxes(true)">All</a> / <a
										class="tableHeaderLink"
										href="javascript:setAllCheckboxes(false)">None</a></th>
								</tr>
							</thead>
							<tbody>
								<c:forEach var="awardResult"
									items="${awardCommand.processedAwardResults}">
									<c:set var="vol"
										value="${awardCommand.volunteersMap[awardResult.volunteerId]}" />

									<tr>
										<td><c:out value="${awardResult.currentAwardName}" /></td>
										<td><c:out value="${awardResult.awardType}" /></td>
										<td align="left"><a
											href="${home}/volunteerEdit.htm?id=${awardResult.volunteerId}"><c:out
													value="${vol.displayName}" /></a></td>
										<td><c:out value="${awardResult.volStatus}" /></td>
										<td align="right" style="display: none"><vss:localDate
												date="${awardResult.dateLastAward}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><span style="display: none"><vss:localDate
													date="${awardResult.dateLastAward}" pattern="${MSD_TO_LSD}" /></span>
											<vss:localDate date="${awardResult.dateLastAward}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><c:out
												value="${awardResult.hoursLastAward}" /></td>
										<td align="right"><c:out
												value="${awardResult.yearsWorked}" /></td>
										<td align="right"><c:out
												value="${awardResult.actualHours}" /></td>
										<td align="right"><c:out value="${awardResult.aveHours}" /></td>
										<td align="right" style="display: none"><vss:localDate
												date="${awardResult.dateLastVolunteered}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="right"><span style="display: none"><vss:localDate
													date="${awardResult.dateLastVolunteered}"
													pattern="${MSD_TO_LSD}" /></span> <vss:localDate
												date="${awardResult.dateLastVolunteered}"
												pattern="${TWO_DIGIT_DATE_ONLY}" /></td>
										<td align="center"><input type="checkbox"
											name="processedVolAwardSelect" value="${vol.id}" /></td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					</td>
				</tr>
			</table>

			<div align="center" style="margin-top: 10px; margin-left: 15px">
				<a id="cancelPostAwardsBtn" class="buttonAnchor"
					href="${current_breadcrumb}">Cancel</a></span>
			</div>
			<div align="right" style="margin-top: -30px; margin-right: 15px">
				<a id="printSelectedButton" class="buttonAnchor"
					href="javascript:printSelected()">Print Labels</a>
			</div>
		</div>
	</c:if>
	<c:if
		test="${awardCommand.awardsProcessed == 1 && empty awardCommand.processedAwardResults && awardCommand.processedSearched}">
		<table align="center" cellpadding="10">
			<tr>
				<td>Sorry, no awards were found that matched the specified
					criteria.</td>
			</tr>
		</table>
	</c:if>

	<input type="hidden" name="${_csrf.parameterName}"
		value="${_csrf.token}" />
</form>



