package gov.va.vss.config;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.collections.EnumerationUtils;

import gov.va.shared.web.support.RequestDataValueProcessorAdaptor;
import gov.va.vss.web.SingleConversationEnforcedCommand;
import gov.va.vss.web.interceptor.SingleSessionConversationInterceptor;

public class EnsureSingleSessionConversationRequestDataValueProcessor extends RequestDataValueProcessorAdaptor {

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, String> getExtraHiddenFields(HttpServletRequest request) {
		HttpSession session = request.getSession();

		Map<String, String> extraParamMap = new HashMap<>();

		EnumerationUtils.toList(session.getAttributeNames()).forEach(p -> {
			Object val = session.getAttribute((String) p);

			if (val instanceof SingleConversationEnforcedCommand) {
				SingleConversationEnforcedCommand c = (SingleConversationEnforcedCommand) val;

				extraParamMap.put(SingleSessionConversationInterceptor.SINGLE_SESSION_CONVERSATION_INPUT_PREFIX + p,
						c.getConversationIdentifier());
			}
		});

		return extraParamMap;
	}

}
