package gov.va.vss.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import gov.va.shared.model.CoreUserDetails;
import gov.va.shared.util.SecurityUtil;
import gov.va.vss.service.volunteer.VolunteerService;

public class SavingSessionLocaleResolver extends SessionLocaleResolver {

	@Autowired
	private VolunteerService volunteerService;

	@Override
	public void setLocaleContext(HttpServletRequest request, HttpServletResponse response,
			LocaleContext localeContext) {
		super.setLocaleContext(request, response, localeContext);
		CoreUserDetails currentUser = SecurityUtil.getCurrentUser();
		if (currentUser != null) {
			Long volunteerId = currentUser.getId();
			volunteerService.updatePreferredLanguage(volunteerId, localeContext.getLocale().getLanguage());
		}
	}

}
