package gov.va.shared.service.impl;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.test.context.support.WithMockUser;

import gov.va.shared.AbstractTransactionalCoreTest;
import gov.va.shared.model.AppUser;
import gov.va.shared.model.Permission;
import gov.va.shared.service.AppUserService;

public class TestAppUserServiceImpl extends AbstractTransactionalCoreTest {

	@Autowired
	private AppUserService appUserService;

	public void login() throws Exception {
		System.out.println("Skipping login");
	}

	@Test(expected = AuthenticationCredentialsNotFoundException.class)
	public void testSaveOrUpdateAnonymous() {
		appUserService.saveOrUpdate(new AppUser());
	}

	@WithMockUser(authorities = Permission.USER_MANAGER)
	public void testSaveOrUpdateAuthenticated() {
		appUserService.saveOrUpdate(new AppUser());
	}

}
