package gov.va.shared.persistence.impl.lookup;

import java.util.List;
import java.util.SortedSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

import gov.va.shared.model.Permission;
import gov.va.shared.persistence.impl.AbstractAppLookupDAOImpl;
import gov.va.shared.persistence.lookup.PermissionDAO;
import gov.va.shared.util.cache.CacheNames;

@Repository
public class PermissionDAOImpl extends AbstractAppLookupDAOImpl<Permission> implements PermissionDAO {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(PermissionDAOImpl.class);

	@Override
	@Cacheable(value = CacheNames.QUERIES_PERMISSION_DAO)
	public List<Permission> findAll() {
		return super.findAll();
	}

	@Override
	@Cacheable(value = CacheNames.QUERIES_PERMISSION_DAO)
	public SortedSet<Permission> findAllSorted() {
		return super.findAllSorted();
	}

	@Override
	@Cacheable(value = CacheNames.QUERIES_PERMISSION_DAO)
	public SortedSet<Permission> findAllSorted(Boolean active) {
		return super.findAllSorted(active);
	}

}
