package gov.va.shared.config.containerOnly;

import javax.sql.DataSource;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;

public abstract class AbstractContainerConfig {

	@Bean
	@Profile({ "attended" })
	public DataSource dataSource() {
		final JndiDataSourceLookup dsLookup = new JndiDataSourceLookup();
		dsLookup.setResourceRef(true);
		DataSource dataSource = dsLookup.getDataSource("jboss/datasources/jdbc/MSSQLXADS");
		return dataSource;
	}

}
