package gov.va.vss.service.scheduledJobs;

import java.util.Collection;
import java.util.concurrent.Callable;

import org.apache.commons.collections15.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.PlatformTransactionManager;

import gov.va.shared.model.AppUser;
import gov.va.shared.model.Permission.PermissionType;
import gov.va.shared.model.Role.RoleType;
import gov.va.shared.persistence.AppUserDAO;
import gov.va.shared.persistence.LdapPersonDAO;
import gov.va.shared.persistence.lookup.sds.VAFacilityDAO;
import gov.va.shared.service.AppUserService;
import gov.va.shared.util.SecurityUtil;
import gov.va.vss.model.SystemUserDetails;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.persistence.dao.ApplicationParametersDAO;
import gov.va.vss.persistence.dao.DonationLogFileDAO;
import gov.va.vss.persistence.dao.PrintRequestDAO;
import gov.va.vss.persistence.dao.facility.FacilityDAO;
import gov.va.vss.persistence.dao.facility.KioskDAO;
import gov.va.vss.persistence.dao.views.FacilityAndVisnDAO;
import gov.va.vss.service.DonationLogService;
import gov.va.vss.service.ExcludedEntityService;
import gov.va.vss.service.KioskService;
import gov.va.vss.service.NotificationService;
import gov.va.vss.service.PrintRequestService;
import gov.va.vss.service.requirement.VolunteerRequirementService;
import gov.va.vss.service.volunteer.VolunteerService;
import gov.va.vss.util.context.BasicContextManager;
import gov.va.vss.util.context.SessionUtil;

public abstract class AbstractScheduledJob {

	@Autowired
	protected ApplicationParametersDAO applicationParametersDAO;
	@Autowired
	protected AppUserDAO appUserDAO;
	@Autowired
	protected AppUserService appUserService;
	@Autowired
	protected DonationLogService donationLogService;
	@Autowired
	protected DonationLogFileDAO donationLogFileDAO;
	@Autowired
	protected FacilityAndVisnDAO institutionAndVisnDAO;
	@Autowired
	protected FacilityDAO facilityDAO;
	@Autowired
	protected ExcludedEntityService excludedEntityService;
	@Autowired
	protected LdapPersonDAO ldapPersonDAO;
	@Autowired
	protected NotificationService notificationService;
	@Autowired
	protected KioskDAO kioskDAO;
	@Autowired
	protected KioskService kioskService;
	@Autowired
	protected PrintRequestDAO printRequestDAO;
	@Autowired
	protected PrintRequestService printRequestService;
	@Autowired
	protected VAFacilityDAO vAFacilityDAO;
	@Autowired
	protected VolunteerService volunteerService;
	@Autowired
	protected VolunteerRequirementService volunteerRequirementService;

	@Autowired
	@Qualifier("transactionManager")
	protected PlatformTransactionManager tm;

	protected AppUser queryUser() {
		return appUserDAO.findByUsername(SecurityUtil.getCurrentUserName(), false);
	}

	protected void runAsBatchJobUser(Callable<?> c) throws Exception {
		Collection<GrantedAuthority> allRolesAndPermissions = CollectionUtils
				.union(PermissionType.getAllAsGrantedAuthorities(), RoleType.getAllAsGrantedAuthorities());
		SecurityContextHolder.getContext().setAuthentication(new UsernamePasswordAuthenticationToken(
				new SystemUserDetails(allRolesAndPermissions), "unimportant", allRolesAndPermissions));

		Facility station101 = facilityDAO.findByStationNumber("101");
		BasicContextManager contextManager = new BasicContextManager(station101, station101.getDisplayName(), 0, true);

		SessionUtil.runWithContext(c, contextManager);
	}

}
