package gov.va.vss.service.impl;

import java.time.ZoneId;
import java.util.Map;
import java.util.SortedSet;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

import gov.va.shared.model.AppUser;
import gov.va.shared.model.lookup.sds.VAFacility;
import gov.va.shared.service.UserAdminCustomizations;
import gov.va.shared.web.AuthenticationCustomizations;
import gov.va.vss.model.facility.Facility;

@Component
public class VssFrameworkCustomizations extends AbstractServiceImpl
		implements UserAdminCustomizations, AuthenticationCustomizations {

	@Value("${userAdmin.newUserDefaultTimezone}")
	private ZoneId newUserDefaultTimezone;
	
	@Override
	public AppUser userRetrievedCallback(AppUser u, Map<String, Object> userAdminCustomizationsModel) {
		return u;
	}

	@Override
	public AppUser userCreatedCallback(AppUser u, Map<String, Object> userAdminCustomizationsModel) {
		u.setTimeZone(newUserDefaultTimezone);
		u = appUserDAO.saveOrUpdate(u);
		return u;
	}

	@Override
	public SortedSet<VAFacility> getAssignableFacilities() {
		return facilityDAO.findVAFacilitiesWithLinkToFacility();
	}

	@Override
	public void userDeletedCallback(long appUserId, Map<String, Object> userAdminCustomizationsModel) {
	}

	@Override
	public void successfulAuthenticationCallback(HttpServletRequest request, Authentication authResult,
			Map<String, Object> authCustomizationsModel) {
		VAFacility vaFacility = gov.va.shared.util.context.SessionUtil.getSiteContext(request.getSession());
		if (vaFacility == null)
			return;

		Facility f = facilityDAO.findByVAFacility(vaFacility.getId());
		sessionUtil.setFacilityContext(vaFacility, f, request.getSession());
	}

}
