package gov.va.vss.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.voluntaryService.VoluntaryServiceParameters;
import gov.va.vss.service.ServiceParametersService;

@Service
public class ServiceParametersServiceImpl extends AbstractServiceImpl implements ServiceParametersService {
	private static final Logger log = LoggerFactory.getLogger(ServiceParametersServiceImpl.class);

	@Override
	public VoluntaryServiceParameters saveOrUpdate(VoluntaryServiceParameters serviceParameters)
			throws ServiceValidationException {
		return serviceParametersDAO.saveOrUpdate(serviceParameters);
	}

	@Override
	public void delete(long serviceParametersId) {
		serviceParametersDAO.delete(serviceParametersId);
	}

}
