package gov.va.vss.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import gov.va.shared.model.Permission.PermissionType;
import gov.va.shared.model.lookup.sds.VAFacility;
import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.shared.util.SecurityUtil;
import gov.va.shared.util.StationsUtil;
import gov.va.vss.model.facility.AdministrativeUnit;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.model.facility.FacilityType.FacilityTypeValue;
import gov.va.vss.service.FacilityService;

@Service
public class FacilityServiceImpl extends AbstractServiceImpl implements FacilityService {
	private static final Logger log = LoggerFactory.getLogger(FacilityServiceImpl.class);

	@Override
	public Facility saveOrUpdate(Facility facility) throws ServiceValidationException {
		/* Business-level validations */
		if (facility.getType() == null)
			facility.setType(facilityTypeDAO.findByLookup(FacilityTypeValue.TIMEKEEPING));
		if (SecurityUtil.hasAllPermissionsAtCurrentFacility(PermissionType.FACILITY_EDIT_ALL)) {
			facility = facilityDAO.saveOrUpdate(facility);
		} else if (SecurityUtil.hasAllPermissionsAtCurrentFacility(PermissionType.FACILITY_EDIT_CURRENT)) {
			stationParametersDAO.saveOrUpdate(facility.getStationParameters());
		}

		return facility;
	}

	@Override
	public void delete(long facilityId) {
		facilityDAO.delete(facilityId);
	}

	@Override
	public void unlinkSDSFacilityFromFacility(long facilityId) {
		facilityDAO.updateFieldsWithoutVersionIncrement(facilityId, true, null, false, null, false, null);
	}

	@Override
	public void linkSDSFacilityToFacility(long facilityId, long vaFacilityId) {
		VAFacility f = vaFacilityDAO.findRequiredByPrimaryKey(vaFacilityId);
		VAFacility sdsVisn = StationsUtil.getVisnForFacilityOrAnyAncestor(f);

		Long visnId = null;
		if (sdsVisn != null) {
			AdministrativeUnit visn = administrativeUnitDAO.findBySDSInstitution(sdsVisn.getId());
			if (visn != null)
				visnId = visn.getId();
		}

		facilityDAO.updateFieldsWithoutVersionIncrement(facilityId, true, vaFacilityId, visnId != null, visnId, true,
				f.getStationNumber());
	}

}
