package gov.va.vss.service;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.facility.StaffTitle;

public interface StaffTitleService {

	/**
	 * @param staffTitle
	 *            The StaffTitle to save or update
	 * @return The updated staffTitle after it's been merged
	 * @throws ServiceValidationException 
	 */
	StaffTitle saveOrUpdate(StaffTitle staffTitle);

	/**
	 * Deletes the Staff Title with the specified staffTitleId
	 * 
	 * @param staffTitleId
	 *            The ID of the staffTitle to delete
	 */
	void delete(long staffTitleId) throws ServiceValidationException;

}
