package gov.va.vss.service;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.benefitingService.BenefitingServiceRoleType;
import gov.va.vss.model.requirement.AbstractRequirement;
import gov.va.vss.model.requirement.RequirementApplicationType;

public interface RequirementService {

	/**
	 * @param requirement
	 *            The Requirement to save or update
	 * @return The updated requirement after it's been merged
	 * @throws ServiceValidationException
	 */
	AbstractRequirement saveOrUpdate(AbstractRequirement requirement) throws ServiceValidationException;

	/**
	 * Deletes the Parking Sticker with the specified parkingStickerId
	 * 
	 * @param requirementId
	 *            The ID of the requirement to delete
	 */
	void delete(long requirementId);

	void changeType(long requirementId, RequirementApplicationType requirementChangeNewType,
			BenefitingServiceRoleType requirementChangeNewRoleType);

	void inactivateRequirement(long id);

	void reactivateRequirement(long id);

}
