package gov.va.vss.service;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.award.Award;

public interface AwardCodeService {

	/**
	 * @param awardCode
	 *            The Award to save or update
	 * @return The updated awardCode after it's been merged

	 */
	Award saveOrUpdate(Long awardCodeId, Award awardCode) throws ServiceValidationException;

	/**
	 * Deletes the Award with the specified awardCodeId
	 * 
	 * @param awardCodeId
	 *            The ID of the award to delete
	 */
	void delete(long awardCodeId) throws ServiceValidationException;

}
