package gov.va.vss.persistence.impl.lookup;

import java.util.SortedSet;
import java.util.TreeSet;

import org.springframework.stereotype.Repository;

import gov.va.vss.model.facility.StaffTitle;
import gov.va.vss.persistence.dao.lookup.StaffTitleDAO;
import gov.va.vss.persistence.impl.GenericHibernateSortedDAOImpl;

@Repository
public class StaffTitleDAOImpl extends GenericHibernateSortedDAOImpl<StaffTitle> implements StaffTitleDAO {
	
	@Override
	@SuppressWarnings("unchecked")
	public SortedSet<StaffTitle> findAllActiveSorted() {
		return new TreeSet<>(
				query("from " + StaffTitle.class.getName() + " s where s.inactive IS FALSE").getResultList());
	}
}
