package gov.va.vss.persistence.impl.lookup;

import org.springframework.stereotype.Repository;

import gov.va.vss.model.lookup.Language;
import gov.va.vss.persistence.dao.lookup.LanguageDAO;
import gov.va.vss.persistence.impl.GenericHibernateLookupDAOImpl;

@Repository
public class LanguageDAOImpl extends GenericHibernateLookupDAOImpl<Language> implements LanguageDAO {

	@Override
	public Language findByLanguageCode(String languageCode) {
		return (Language) query("select l from " + Language.class.getName() + " l where SUBSTRING(l.culture, 1, "
				+ languageCode.length() + ") = :language").setParameter("language", languageCode).getSingleResult();
	}

}
