package gov.va.vss.persistence.dao.volunteer;

import java.util.Collection;
import java.util.List;

import gov.va.vss.model.volunteer.VolunteerOrganization;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public interface VolunteerOrganizationDAO extends CustomizableAppDAO<VolunteerOrganization> {

	List<VolunteerOrganization> findByCriteria(Long volunteerId, Long organizationId, Boolean activeStatus,
			Long organizationFacilityId, QueryCustomization... customization);

	int bulkUpdateByCriteria(Collection<Long> orgOrBranchIds, Boolean currentActiveStatus, Boolean newActiveStatus);

	int bulkUpdatePrimaryOrganizationsByCriteria(Collection<Long> organizationIds, boolean setPrimaryOrganization,
			Long primaryOrganizationId);
	
	int inactivateForInactiveVolunteers();

}
