package gov.va.vss.persistence.dao.volunteer;

import java.util.List;

import gov.va.vss.model.notification.Notification;
import gov.va.vss.model.voluntaryService.VoluntaryServiceStaff;
import gov.va.vss.persistence.dao.CustomizableAppDAO;

public interface VoluntaryServiceStaffDAO extends CustomizableAppDAO<VoluntaryServiceStaff> {

	/**
	 * 
	 * @param appUserName
	 *            TODO
	 * @param stationNum
	 *            TODO
	 * @return The list of Voluntary Service Staff matching the above criteria
	 */
	List<VoluntaryServiceStaff> findByCriteria(Long facilityId, String appUserName);

	/**
	 * 
	 * @param staffTitleId
	 * @return The list of Voluntary Service Staff with the given staff title
	 */
	List<VoluntaryServiceStaff> findByStaffTitle(long staffTitleId);

	List<VoluntaryServiceStaff> findLinkedToNotification(Notification notification);

}
