package gov.va.vss.persistence.dao.requirement;

import java.util.List;

import gov.va.vss.model.requirement.AbstractVolunteerRequirement;
import gov.va.vss.model.requirement.VolunteerRequirement;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public interface VolunteerRequirementDAO extends CustomizableAppDAO<VolunteerRequirement> {

	int bulkAddNecessaryRequirements(Long volunteerIdCreatedOrUpdated, Long requirementIdCreatedOrUpdated,
			Long benefitingServiceRoleIdModified, Long benefitingServiceRoleTemplateIdModified);

	/**
	 * List all requirements for volunteer including national as well as as
	 * local facility for localFacilityId
	 * 
	 * @param localFacilityId
	 * @return
	 */
	<T extends AbstractVolunteerRequirement> List<T> findByCriteria(Class<T> clazz, long volunteerId, Long facilityId,
			QueryCustomization... customization);

	int bulkUpdateDateToNull(long requirementId);

	int bulkUpdateInvalidStatusesToNew(long requirementId);

	Integer removeUnnecessaryVolunteerRequirementsInNewStatus();

	List<AbstractVolunteerRequirement> findUnmetRequirements(long volunteerId, long facilityId);

	int countByCriteria(long requirementId);

	int deleteByCriteria(long requirementId);

	int updateAllIncorrectStatuses();

	List<VolunteerRequirement> findForExpiringRequirements(long facilityId, Long volunteerId, int maxResults);

}
