package gov.va.vss.persistence.dao.benefitingService;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import gov.va.vss.model.benefitingService.BenefitingServiceRoleTemplate;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public interface BenefitingServiceRoleTemplateDAO extends CustomizableSortedDAO<BenefitingServiceRoleTemplate> {

	List<BenefitingServiceRoleTemplate> findByCriteria(String name, Boolean activeStatus,
			QueryCustomization... customization);

	Map<Long, Integer[]> countVolunteersForBenefitingServiceRoleTemplateIds(Collection<Long> allRoleTemplateIds);

	int bulkUpdateByCriteria(Long benefitingServiceTemplateId, Boolean roleIsRequiredAndReadOnly, Boolean activeStatus);
	
	int bulkDeleteByCriteria(Long benefitingServiceTemplateId);
	
}
