package gov.va.vss.persistence.dao;

import java.util.SortedSet;

import gov.va.shared.model.core.IdentifiedPersistent;
import gov.va.shared.persistence.AppSortedDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

@SuppressWarnings("rawtypes")
public interface CustomizableSortedDAO<T extends Comparable & IdentifiedPersistent>
		extends CustomizableAppDAO<T>, AppSortedDAO<T> {

	SortedSet<T> findAllSorted(QueryCustomization customization);

	<U extends T> SortedSet<U> findAllSortedByType(Class<U> subtype, QueryCustomization customization);

}
