package gov.va.vss.model.organization;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.shared.model.core.AuditedVersionedPersistent;
import gov.va.shared.model.lookup.sds.State;
import gov.va.vss.model.ObjectScopedToStationNumbers;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.model.time.WorkEntry;
import gov.va.vss.model.volunteer.VolunteerOrganization;

public interface BasicOrganization
		extends AuditedVersionedPersistent, Comparable<BasicOrganization>, ObjectScopedToStationNumbers {

	Organization getRootOrganization();

	boolean isActive();

	String getDisplayName();

	String getAddressMultilineDisplay();

	String getScale();

	ScopeType getScope();

	Facility getFacility();

	String getAbbreviation();

	String getName();

	String getFullName();

	boolean isInactive();

	List<VolunteerOrganization> getVolunteerOrganizations();

	String getAddressLine1();

	String getAddressLine2();

	String getCity();

	State getState();

	String getZip();

	String getEmail();

	String getPhone();

	List<WorkEntry> getWorkEntries();

	String getContactName();

	String getContactTitle();

}