@echo off
setlocal

set ROOT=%VSS_CC_PATH%
set COMMON=%ROOT%\common_web\src\main\webapp\WEB-INF\jsp
set WEB=%ROOT%\web\src\main\webapp\WEB-INF\jsp
set WEB_KIOSK=%ROOT%\kiosk\src\main\webapp\WEB-INF\jsp

call cleancompile.bat

sourceanalyzer.exe -b "web" -clean
sourceanalyzer.exe -b "kiosk" -clean
sourceanalyzer.exe -b "print" -clean

del /F /S /Q %TEMP%\vss-fortify
rmdir %TEMP%\vss-fortify
mkdir %TEMP%\vss-fortify
cd %ROOT%\web
call mvn dependency:copy-dependencies -DoutputDirectory=%TEMP%\vss-fortify -s %MAVEN_SETTINGS_FILE%
del /F /Q %TEMP%\vss-fortify\vss_common-%VSS_VERSION%.jar
del /F /Q %TEMP%\vss-fortify\*.war
del /F /Q %TEMP%\vss-fortify\*.pom

del /F /S /Q %TEMP%\vss-fortify-kiosk
rmdir %TEMP%\vss-fortify-kiosk
mkdir %TEMP%\vss-fortify-kiosk
cd %ROOT%\web
call mvn dependency:copy-dependencies -DoutputDirectory=%TEMP%\vss-fortify-kiosk -s %MAVEN_SETTINGS_FILE%
del /F /Q %TEMP%\vss-fortify-kiosk\vss_common-%VSS_VERSION%.jar
del /F /Q %TEMP%\vss-fortify-kiosk\*.war
del /F /Q %TEMP%\vss-fortify-kiosk\*.pom

del /F /S /Q %TEMP%\vss-fortify-print
rmdir %TEMP%\vss-fortify-print
mkdir %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\commons-logging\commons-logging\1.2\commons-logging-1.2.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\com\fasterxml\jackson\core\jackson-annotations\2.7.4\jackson-annotations-2.7.4.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\net\java\dev\jna\jna\4.2.2\jna-4.2.2.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\commons-io\commons-io\2.5\commons-io-2.5.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\com\fasterxml\jackson\core\jackson-databind\2.7.4\jackson-databind-2.7.4.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\commons-codec\commons-codec\1.10\commons-codec-1.10.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\com\fasterxml\jackson\core\jackson-core\2.7.4\jackson-core-2.7.4.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\org\apache\httpcomponents\httpclient\4.5.2\httpclient-4.5.2.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\net\java\dev\jna\jna-platform\4.2.2\jna-platform-4.2.2.jar %TEMP%\vss-fortify-print
copy %MAVEN_REPO_LOC%\org\apache\httpcomponents\httpcore\4.4.4\httpcore-4.4.4.jar %TEMP%\vss-fortify-print

@rem --------- copy web files since Fortify doesn't know where these live

copy %COMMON%\shared\inc_header.jsp %WEB%\shared
copy %COMMON%\root\javascript\inc_oneTimeUserNotification.jsp %WEB%\root\javascript
copy %COMMON%\root\javascript\inc_sounds.jsp %WEB%\root\javascript
copy %COMMON%\root\javascript\inc_common.jsp %WEB%\root\javascript
copy %COMMON%\root\javascript\inc_javascriptForCountdownTimer.jsp %WEB%\root\javascript
copy %COMMON%\root\javascript\inc_confirmationDialog.jsp %WEB%\root\javascript
copy %COMMON%\root\javascript\inc_attentionDialog.jsp %WEB%\root\javascript
copy %COMMON%\root\inc_contextualHelp.jsp %WEB%\root

@rem --------- copy kiosk files since Fortify doesn't know where these live

mkdir %WEB_KIOSK%\root
mkdir %WEB_KIOSK%\root\javascript
mkdir %WEB_KIOSK%\shared
copy %COMMON%\shared\inc_header.jsp %WEB_KIOSK%\shared
copy %COMMON%\root\javascript\inc_oneTimeUserNotification.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\javascript\inc_sounds.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\javascript\inc_common.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\javascript\inc_javascriptForCountdownTimer.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\javascript\inc_confirmationDialog.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\javascript\inc_attentionDialog.jsp %WEB_KIOSK%\root\javascript
copy %COMMON%\root\inc_contextualHelp.jsp %WEB_KIOSK%\root

@rem uncomment this to skip scans and just test file creation
@rem goto postFortify

@rem ------------- Run Fortify for the web project

sourceanalyzer.exe -b web -machine-output -cp %TEMP%\vss-fortify\*.jar -source 1.8 -Xmx12G -Xss32M ^
-exclude %ROOT%\common\target ^
-exclude %ROOT%\core\target ^
-exclude %ROOT%\common_web\target ^
-exclude %ROOT%\web\target ^
-exclude %ROOT%\web\target-eclipse ^
-exclude %ROOT%\core\target-eclipse ^
-exclude %ROOT%\common\target-eclipse ^
%ROOT%\lib %ROOT%\web %ROOT%\common %ROOT%\core %ROOT%\common_web
@rem -debug ^
@rem -verbose ^
@rem -logfile scan.log

sourceanalyzer.exe -b web -machine-output -format fpr -f %ROOT%\web\vss_web_scan_new.fpr -scan -Xmx12G -Xss32M
@rem -debug ^
@rem -verbose ^
@rem -logfile scan2.log

call FPRUtility -merge ^
-project %ROOT%\web\vss_web_scan.fpr ^
-source %ROOT%\web\vss_web_scan_new.fpr ^
-f %ROOT%\web\vss_web_scan_merged.fpr

if not exist %ROOT%\web\vss_web_scan_merged.fpr goto :exit
del /F /Q %ROOT%\web\vss_web_scan.fpr
del /F /Q %ROOT%\web\vss_web_scan_new.fpr
ren %ROOT%\web\vss_web_scan_merged.fpr vss_web_scan.fpr

@rem ------------- Run Fortify for the kiosk project

sourceanalyzer.exe -b kiosk -machine-output -cp %TEMP%\vss-fortify-kiosk\*.jar -source 1.8 -Xmx12G -Xss32M ^
-exclude %ROOT%\common\target ^
-exclude %ROOT%\kiosk\target-eclipse ^
-exclude %ROOT%\core\target ^
-exclude %ROOT%\common_web\target ^
-exclude %ROOT%\core\target-eclipse ^
-exclude %ROOT%\common\target-eclipse ^
-exclude %ROOT%\kiosk\target ^
%ROOT%\lib %ROOT%\kiosk %ROOT%\common %ROOT%\core %ROOT%\common_web

sourceanalyzer.exe -b kiosk -machine-output -format fpr -f %ROOT%\kiosk\vss_kiosk_scan_new.fpr -scan -Xmx12G -Xss32M

call FPRUtility -merge ^
-project %ROOT%\kiosk\vss_kiosk_scan.fpr ^
-source %ROOT%\kiosk\vss_kiosk_scan_new.fpr ^
-f %ROOT%\kiosk\vss_kiosk_scan_merged.fpr

if not exist %ROOT%\kiosk\vss_kiosk_scan_merged.fpr goto :exit
del /F %ROOT%\kiosk\vss_kiosk_scan.fpr
del /F %ROOT%\kiosk\vss_kiosk_scan_new.fpr
ren %ROOT%\kiosk\vss_kiosk_scan_merged.fpr vss_kiosk_scan.fpr

@rem ------------- Run Fortify for the print project

sourceanalyzer.exe -b print -machine-output -cp %TEMP%\vss-fortify-print\*.jar -source 1.8 -Xmx12G ^
-exclude %ROOT%\print\target ^
%ROOT%\print 

sourceanalyzer.exe -b print -machine-output -format fpr -f %ROOT%\print\vss_print_scan_new.fpr -scan -Xmx12G

call FPRUtility -merge ^
-project %ROOT%\print\vss_print_scan.fpr ^
-source %ROOT%\print\vss_print_scan_new.fpr ^
-f %ROOT%\print\vss_print_scan_merged.fpr

if not exist %ROOT%\print\vss_print_scan_merged.fpr goto :exit
del /F %ROOT%\print\vss_print_scan.fpr
del /F %ROOT%\print\vss_print_scan_new.fpr
ren %ROOT%\print\vss_print_scan_merged.fpr vss_print_scan.fpr

:postFortify

@rem ------------- clean up after Web fortify scan

del /F /Q %WEB%\shared\inc_header.jsp
del /F /Q %WEB%\root\javascript\inc_oneTimeUserNotification.jsp
del /F /Q %WEB%\root\javascript\inc_sounds.jsp
del /F /Q %WEB%\root\javascript\inc_common.jsp
del /F /Q %WEB%\root\javascript\inc_javascriptForCountdownTimer.jsp
del /F /Q %WEB%\root\javascript\inc_confirmationDialog.jsp
del /F /Q %WEB%\root\javascript\inc_attentionDialog.jsp
del /F /Q %WEB%\root\inc_contextualHelp.jsp

@rem ------------- clean up after Kiosk fortify scan

del /F /Q %WEB_KIOSK%\shared\inc_header.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_oneTimeUserNotification.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_sounds.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_common.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_javascriptForCountdownTimer.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_confirmationDialog.jsp
del /F /Q %WEB_KIOSK%\root\javascript\inc_attentionDialog.jsp
del /F /Q %WEB_KIOSK%\root\inc_contextualHelp.jsp
rmdir %WEB_KIOSK%\root\javascript
rmdir %WEB_KIOSK%\root
rmdir %WEB_KIOSK%\shared

@rem ------------- zip source

call cleanAndZipSource.bat

for %%I in ("%VSS_CC_PATH%\..") do set "VSS_CC_PARENT=%%~fI"

@rem remove help and properties from the source zip
for %%f in (%VSS_CC_PATH%) do set foldername=%%~nxf
7z d -r %VSS_CC_PATH%.zip %foldername%/help
7z d -r %VSS_CC_PATH%.zip %foldername%/properties

copy %ROOT%\web\vss_web_scan.fpr %VSS_CC_PARENT%
copy %ROOT%\kiosk\vss_kiosk_scan.fpr %VSS_CC_PARENT%
copy %ROOT%\print\vss_print_scan.fpr %VSS_CC_PARENT%

echo Files prepared in %VSS_CC_PARENT%.

:exit
endlocal