"use strict";
const config   = require("config");
const $        = require("../gulp/config");


/**
 *
 *	Here's the list of descriptions that need to be edited as to what this test is supposed to do
 *
 **/
const Descriptions = [
	/* First entry is the top level description */
	{
		"ID" : "415",
		"Type" : "US",
		"Num" : "AP-10-010",
		"Desc" : "User Login to Application"
	},
	/* Next entry(s) are for the individual items in the test */
	{
		"ID" : "416",
		"Type" : "F",
		"Num" : "AP-10-010-GUI1",
		"Desc" : "Create Login Screen",
		"fnc": "CreateLoginScreen"
	},

	{
		"ID" : "417",
		"Type" : "F",
		"Num" : "AP-10-010-API1",
		"Desc" : "Provide Mechanism to Authenticate User",
		"fnc": "AuthenticateUser"
	}
];


/**
 *
 *	Here are the tests to be performed as listed in the "fnc" items above.
 *
 **/
const CreateLoginScreen = function() {
	return true;
}
const AuthenticateUser = function() {
	return false;
}























/**
* Don't touch this code here
**/

const build_Desc = function(idx) {
	let d = Descriptions[idx];
	return d.ID + " - " + d.Type + ": " + d.Num + " - " + d.Desc;
}

const runTest = function(idx) {
	it(build_Desc(idx), function(done) {
		let d = Descriptions[idx];
		let f = eval(d.fnc)();
		if (f) {
			$.chai.expect(d.fnc).to.be.true;	
		}
		else {
		 	$.chai.expect(d.fnc).to.be.true;
		}
		done();
	});
}


describe(build_Desc(0), function(){
	var i;
	for (i = 1; i < Descriptions.length; i++) {
		runTest(i);
	}
});
