"use strict";
const config   = require("config");
const $        = require("../gulp/config");
const cvm      = require("../src/js/utils/can_view_menu");
const theMap   = require("../src/js/utils/view_roles_map.json");
const expect   = $.chai.expect;

/**
 *
 *	Here's the list of descriptions that need to be edited as to what this test is supposed to do
 *
 **/
const Descriptions = [
	/* First entry is the top level description */
	{
		"ID" : "553",			// Issue #
		"Type" : "F",			// Feature
		"Num" : "SS-10-040",	// Number
		"Desc" : "Implement Role Access Control for all Menu Options/Views"
	},
	/* Next entry(s) are for the individual items in the test */
	{
		"ID" : "416",
		"Type" : "F",
		"Num" : "SS-10-040-GUI2",
		"Desc" : "Check for Role Access of Menu",
		"fnc": "cvm2"
	},

	{
		"ID" : "417",
		"Type" : "F",
		"Num" : "AP-10-010-API1",
		"Desc" : "Provide Mechanism to Authenticate User",
		"fnc": "AuthenticateUser"
	}
];


/**
 *
 *	Here are the tests to be performed as listed in the "fnc" items above.
 *
 **/
const views = [
	"Patient Management", 
	"Surgery Monitoring", 
	"Non-O.R. Procedures", 
	"Schedule Operations", 
	"Operations", 
	"Anesthesia", 
	"Perioperative Occurrences", 
	"Surgery Risk Assessment", 
	"Chief of Surgery", 
	"Surgery Package Management", 
	"CPT/ICD Coding"
];

const roles = [
	"National Surgery Admin",
	"Facility Surgery Admin",
	"Surgical Case Admin",
	"Surgery Case Scheduler",
	"Surgery Case Requestor",
	"Surgery Staff",
	"Surgery Coder"
];

const userRoles = [
	"Surgery Case Scheduler",
	"Waiting Room User"
];

const cvm1 = function() {
	for (let aView of views) {
		let CanDo = [];
		let CanNOTDo = [];
		let theViewObj = theMap.viewRoles.find(anObject => anObject.viewName == aView);
		for (let aRole of roles) {
			if (theViewObj.roles.find(aRoleObj => aRoleObj == aRole)) {
				if (cvm.canViewMenu(aView, aRole)) {
					CanDo.push (aRole);
				}
			}
			else {
				if(!cvm.canViewMenu(aView, aRole)) {
					CanNOTDo.push(aRole);
				}
			}
		}
		let s1 = `${aView} can be accessed by the following roles \n          ${CanDo.join("\n          ")}`;
		let s2 = `${aView} can NOT be accessed by the following roles \n          ${CanNOTDo.join("\n          ")}-`;

		it (s1, function(done) { if (CanDo) { done(); } });
		it (s2, function(done) { if (CanNOTDo) { done(); } });
	}
};

const cvm2 = function() {
	const myViews = cvm.availableViews(views, userRoles);
	const msg = `A user with the following Roles = \n        ${userRoles.join("\n        ")}\n     can see the following views = \n        ${myViews.join("\n        ")}"`;
	it (msg, function(done) {if (myViews) {done();}});
}

/**
* Don't touch this code here
**/

const build_Desc = function(idx) {
	let d = Descriptions[idx];
	return d.ID + " - " + d.Type + ": " + d.Num + " - " + d.Desc;
}

describe(build_Desc(0), function(){
	cvm1();
	cvm2();
});
