const Marionette = require("backbone.marionette");
const SelectPicker = require("../../behaviors/select-picker");

module.exports = Marionette.StateView.extend({
	tagName: "select",
	className: "selectpicker",
	template: require("./template.hbs"),

	selected: null,
	container: "body",
	liveSearch: true,
	showTick: true,
	title: "Select one of the following",

	defaultState() {
		return {
			selected: this.getOption("selected")
		};
	},

	behaviors() {
		return {
			SelectPicker: {
				behaviorClass: SelectPicker,
				selector: "this",
				options: {
					container: this.getOption("container"),
					size: this.getOption("size"),
					liveSearch: this.getOption("liveSearch"),
					showTick: this.getOption("showTick"),
					title: this.getOption("title"),
				}
			}
		};
	},

	attributes() {
		return {
			"aria-labelledby": this.getOption("ariaLabel"),
			disabled: this.getOption("disabled")
		};
	},

	valueKey: "id",
	labelKey: "dspData",

	serializeCollection() {
		if (!this.collection) { return {}; }
		const ret = this.collection.map(function (model) {
			return {
				id: model.get(this.getOption("valueKey")),
				dspData: model.get(this.getOption("labelKey"))
			};
		}, this);
		return ret;
	},

	triggers: {
		change: "change:value"
	},

	onChangeValue() {
		this.state.set("selected", this.$el.val());
	},

	getValue() {
		return this.state.get("selected");
	},

	setValue(value) {
		this.$el.val(value);
		this.triggerMethod("selectpicker:update");
	}
});
