const storage = require("./storage");

module.exports = {
	auth: {
		before() {

			// If the user hasn't authenticated, redirect them to the login,
			// passing the current URI to return to once complete
			if (!storage.getItem("access_token")) {
				const currentUrl = global.location.pathname;
				this.navigate(`/login/?return=${currentUrl}`, { trigger: true, replace: true });
			}
		}
	}
};
