const Radio = require("backbone.radio");
const storage = require("./storage");

module.exports = function manageToken(entity) {
	entity.on("error", (state, err) => {

		// This will get triggered on any error response, but we're only
		// concerned if it failed due to the user's authentication token
		// expiring.
		//
		// Once the expired token response is updated to return a 403 instead
		// of 401 we can remove the gross .indexOf() case
		if (403 === err.status || err.responseText.indexOf("TokenExpiredError") > -1) {

			// Remove old token, as the login will enter an infinite loop
			// if it's still there, plus its expired so we have no use
			// for it anyway.
			storage.removeItem("access_token");

			// Redirect to the login, passing the current URL to return to
			const currentUri = global.location.pathname;
			Radio.request("global", "navigate", `/login/?return=${currentUri}`, {
				trigger: true,
				replace: true
			});
		}
	});
};
