const EntitySelectView = require("./abstract");
const FieldsCollections = require("../../entities/fields/collections");

const FieldSelectViews = {};

for (let field in FieldsCollections) {
	if (! FieldsCollections.hasOwnProperty(field)) continue;
	let fieldCollection = FieldsCollections[field];

	let newSelectView =  EntitySelectView.extend({
		CollectionClass: fieldCollection,
		dataKey: field,
		label: "value",
		value: "code"
	});
	FieldSelectViews[field] = newSelectView;
}

module.exports = FieldSelectViews;
