const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");

module.exports = Sciatic.Router.extend({
	filters: [
		{
			before(routeData) {
				// Set the currently logged-in user to the routeData
				// on every route transition
				routeData._user = Radio.request("auth", "user");
			}
		}
	],

	routes: {
		"": require("./modules/index/route"),
		"login/": require("./modules/login/route"),
		"case/:view/": require("./modules/case/route"),
		"calendar/": require("./modules/calendar/route"),
		// "selpatient/": require("./modules/sel_patient/route"),
		"rooms/": require("./modules/rooms/route"),
		"admin_ur_config/": require("./modules/administration/user_role_config/route"),
		"admin_rt_config/": require("./modules/administration/room_type_config/route"),
		"admin_sslqi/": require("./modules/administration/sslqi/search/route"),
		"admin_sslqi/:id/": require("./modules/administration/sslqi/edit/route"),
		"proc_cat_management/": require("./modules/administration/proc_cat_management/route"),

		"admin_other_config/": require("./modules/administration/other_config/route"),
		"admin_other_cases/": require("./modules/administration/poc_other_cases/route"),
		"admin_other_poc/": require("./modules/administration/poc_select_tooltip/route"),

		"reports/case_duration_times/": require("./modules/reports/case_duration/route")
	}
});
