// const _          = require("underscore");
const Marionette = require("backbone.marionette");
const Radio      = require("backbone.radio");
require("bootstrap-select");

const PatientNameCollection   = require("../../entities/patient/collection");

const storage    = require("../../utils/storage");
const aheader    = require("../../utils/authHeaders");
const SelectView = require("../../utils/select/view");

const SelPatientShowView = require("./show/view");

module.exports = Marionette.StateView.extend({
	template: require("./template.hbs"),
	defaultState: {
		"loading": true
	},
	stateEvents: {
		"change": "render"
	},

	regions: {
		"nameField": "#PatientInfo"
	},

	triggers: {
		"click #selectPatientButton": "click:selectPatient"
	},

	onAttach: function() {
		this.loadPatientList();
	},

	loadPatientList() {
		this.collection = new PatientNameCollection();
		return this.collection.fetch(aheader())
			.then(() => this.state.set("loading", false));
	},

	onRender: function () {
		if (!this.state.get("loading")) {
			let i = 0, colLen = this.collection.length;
			for (i = 0; i < colLen; i++) {
				this.collection.models[i].attributes.dspData = this.collection.models[i].get("name") + " - " + this.collection.models[i].get("lastFive");
				this.collection.models[i].attributes.id = this.collection.models[i].get("dfn");
			}
			const selectView = new SelectView({
				"collection": this.collection,
				"ariaLabel": "PatientInfoLabel",
				"size": 5
			});
			this.showChildView("nameField", selectView);
		}
	},

	onChildviewChangeValue() {
		const selectedPatientDFN = this.getChildView("nameField").state.get("selected");
		const selectedPatient = this.collection.findWhere({dfn: selectedPatientDFN});
		this.SelectedPatient = selectedPatient;
	},

	onClickSelectPatient() {
		const singlePatientRecord = this.SelectedPatient;
		if (singlePatientRecord) {
			console.log("Single Patient Record::",
						singlePatientRecord.toJSON());
			/* singlePatientRecord currently came from a collection, which
			   means it isn't the full record.  Do a fetch so that the full
			   patient record will be loaded. */
			singlePatientRecord.fetch(aheader());
			Radio.request("root", "modal", {
				view: new SelPatientShowView({model: singlePatientRecord})
			});
		}
	}
});
