const Marionette = require("backbone.marionette");
const SchedulerView = require("./scheduler/view");
const FilterView = require("./selector/view");

module.exports = Marionette.View.extend({
	className: "flexIt flexIt-container commonPanel",
	template: require("./template.hbs"),

	regions: {
		filters: {
			el: ".js-region-filters",
			replaceElement: true
		},
		scheduler: {
			el: ".js-region-scheduler",
			replaceElement: true
		}
	},

	onAttach() {
		let displayDate = this.getOption("date");
		if (displayDate == null){
			displayDate = new Date();
		}
		this.showChildView("filters", new FilterView({date: displayDate}));
		this.showChildView("scheduler", new SchedulerView({rooms: this.getOption("rooms")}));
	}
});