const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const formatDate = require("../../../utils/format_date").formatDate;

module.exports = Marionette.View.extend({
	template: require("./template.hbs"),
	templateContext(){
		return {
			date: formatDate(new Date(this.getOption("date")))
		};
	},
	ui: {
		dateField: ".dateHiddenField"
	},
	events: {
		"change @ui.dateField": "handleNewDate"
	},
	onDomRefresh() {
		$( "button.date-calendar" ).datetimepicker({
			timepicker:false,
			format: "YYYY-MM-DD",
			onChangeDateTime:function(dp,$input){
				$(".dateHiddenField").val($input.val()).change();
			}
		});
	},
	handleNewDate() {
		console.log("on change fired");
		const date = this.getUI("dateField").val();
		Radio.request("global", "navigate", `/rooms/?date=${date}`);
	}

});