
const { Route } = require("backbone.sciatic");
const Radio = require("backbone.radio");
const RoomsView = require("./view");
const RoomCollection = require("../../entities/room/collection");
const authHeaders = require("../../utils/authHeaders");

module.exports = Route.extend({
	fetch(routeData) {
		routeData.rooms = new RoomCollection();
		let scheduleDate = new Date();
		if(routeData.query.date)
			scheduleDate = new Date(routeData.query.date+"T00:00:00-0400");
		if(!scheduleDate)
			scheduleDate = new Date();
		return routeData.rooms.fetch(authHeaders()).then(() => Promise.all(
			routeData.rooms.map(room => room.fetchEvents(scheduleDate))
		))
		.catch(err => console.error(err));

	},
	show(routeData) {
		let scheduleDate = new Date();
		if(routeData.query.date)
			scheduleDate = new Date(routeData.query.date+"T00:00:00-0400");
		if(!scheduleDate)
			scheduleDate = new Date();
		Radio.request("root", "body", new RoomsView({rooms: routeData.rooms, date: scheduleDate}));
	}
});