const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const IndexView = require("../../../modules/index/view");

module.exports = Marionette.StateView.extend({
	template: require("./template.hbs"),

	templateContext() {
	},

	ui: {
		ok: "#ok",
		cancel: "#cancel",
		close: "#close",
		question: "#question"
	},

	triggers: {
		"click @ui.ok": "ok",
		"click @ui.cancel": "cancel",
		"click @ui.close": "close",
		"click @ui.question": "question",

	},

	onOk() {
		Radio.request("root", "close:modal");
		Backbone.history.navigate( "/", { trigger: false, replace: true } );
		Radio.request("root", "body", new IndexView({}));
	},

	onCancel() {
		Radio.request("root", "close:modal");
	},

	onClose() {
		Radio.request("root", "close:modal");
	},

	onQuestion() {
		Radio.request("root", "close:modal");
		let href = "https://ehmp.vistacore.us/help/eHMP_Page%20Not%20Found.htm";
		let left = (screen.width/2)-(900/2);
		let top = (screen.height/2)-(600/2);
		window.open(href, "Widget Help", `top=${top}, left=${left}, width=800, height=450`);
	},

	onAttach() {
		console.log("Attaching Cancel view");
	}
});
