const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");

module.exports = Marionette.StateView.extend({
	template: require("./template.hbs"),

	templateContext() {
		// options passed to the view
		const selType = this.getOption("type");
		return {
			// Add any/all properties we want to display here
			prop: selType,
			label: "Some Property"
		};
	},

	ui: {
		ok: ".js-selCase-OK"  // class assigned to the "OK" button in the template
	},

	triggers: {
		"click @ui.ok": "ok"    // triggered by the "ok" property of the "ui" object
	},

	onOk() {    // handler for the click event of the trigger above
		Radio.request("root", "close:modal");
	},

	onAttach() {  // called when first attaching the view
		console.log("Attaching N/A view");
	}
});
