const mn    = require("backbone.marionette");
const Radio = require("backbone.radio");
const storage   = require("../../../utils/storage");
const NotificationCollection   = require("../../../entities/notification/collection");
const authHeaders = require("../../../utils/authHeaders");
const TooltipBehavior = require("../../../behaviors/tooltip");


module.exports = mn.View.extend({
	template: require("./template.hbs"),
	tagName: "nav",
	className: "navbar",

	behaviors: { TooltipBehavior },

	initialize() {
		// Collect relevant data from various Radio channels
		Object.assign(this.options, {
			user: Radio.request("auth", "user"),
			facility: Radio.request("store", "get", "activeFacility")
		});
	},
	templateContext() {
		const user = this.getOption("user");
		const facility = this.getOption("facility");

		const data = {
			user: user ? user.toJSON() : undefined,
			facility: facility ? this.facilityConversion(facility) : undefined
		};
		return data;
	},

	onRender() {
		// Note: User Info, Facility Info are all expanded by default
		if (this.getOption("user")) {
			$("#collapseUserInfo").collapse("show");
		}
		if (this.getOption("facility")) {
			$("#collapseFacilityInfo").collapse("show");
		}
	},

	facilityConversion(f) {
		const facility = f.toJSON();
		return {
			"facilityName": storage.getItem("facilityName"),
			"Station ID": facility.stationID,
			"Complexity Level": facility.complexityLevel,
			"Facility Size": facility.facilitySize,
			"State": facility.state,
			"VISN": facility.visn
		};
	},
	onAttach() {
		this.listenTo(Radio.channel("auth"), "user:authenticate", this.handleLogin, this);
		this.listenTo(Radio.channel("store"), {
			"change:activeFacility": this.updateFacility
		}, this);
	},
	onBeforeDestroy() {
		this.stopListening(Radio.channel("auth"));
	},

	handleLogin(user) {
		Object.assign(this.options, { user });
		this.render();
	},

	updateFacility(facility) {
		Object.assign(this.options, { facility });
		this.render();
	},

	triggers: {
		"click .js-Logout": "select:Logout",
		"click #notification-link": "notification:Show"
		//"mouseover #notification-link": "notification:Show"
	},

	onSelectLogout() {
		storage.clear();
		// location.reload();
		location.pathname = "/";
		location.replace("/");
	},

	onNotificationShow(event){
		const user = this.getOption("user");

		let $notification_link = $("a#notification-link");
		let $notification_list = $("a#notification-link").next(".dropdown-menu");
		let bell_icon = $notification_link.html();
		// put in a loading icon instead of bell
		$notification_link.empty().html("<li><i class=\"fa fa-refresh fa-spin fa-fw\"></i><span class=\"sr-only\">Loading...</span></li>");
		// empty previous notifications
		$notification_list.empty();
		// get new notifications from API
		const notifications = new NotificationCollection([], {"user_ien": user.get("ien")});
		notifications.fetch(authHeaders()).then(function(){
			notifications.each(function(notification){
				$notification_list.append("<li class="+notification.get("read")+">"
					+"<a href='"+notification.get("action")+"'>"+notification.get("text")+"</a</li>");
			});
		});
		// reset the bell
		$notification_link.html(bell_icon);

	}
});
