const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");

const CaseView = require("./view");
const CaseListView = require("./case_list/view");

const { auth } = require("../../utils/mixins");

module.exports = Sciatic.Route.extend({
	filters: [auth],
	show(routeData) {
		console.log("rd:", routeData.params.view);
		if (routeData.params.view === "new") {
			Radio.request("root", "body", new CaseView({mode: "new"}));
		}

		if (routeData.params.view === "filter") {
			Radio.request("root", "body", new CaseListView({mode: "filter"}));
		}

		if (/^\d+$/.test(routeData.params.view)) { // case id
			Radio.request("root", "body", new CaseView({mode: "view", case_id:
								routeData.params.view}));
		}
	}
});
