const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");
const _        = require("lodash");

// Expected fields: ref, name
const TabModel = Backbone.Model.extend({});
const TabsCollection = Backbone.Collection.extend({
	model: TabModel
});

const TabStub = Marionette.View.extend({
	tagName: "li",
	className: "tab-li",
	template: require("./tab_top.hbs"),
	triggers: {
		"click": "select:tab"
	},
	templateContext: function () {
		return {
			idx: this.model.get("ref").slice(-1),
			name: this.model.get("name")
		};
	},
	onRender: function () {
		this.$el.attr("id", "tabStub" + this.model.get("ref").slice(-1));
	}
});

const TabTops = Marionette.CollectionView.extend({
	tagName: "ul",
	className: "tab-links tab-to-body-space",
	childView: TabStub,
	childViewEvents: {
		"select:tab": "tabSelected"
	},
	tabSelected: function (childView) {
		this.trigger("tab_select", childView.model.get("ref"));
	},
	onRender: function () {
		this.$("li#tabStub" + this.options.selectedIdx).addClass("active");
	}
});

module.exports = function (tabs, options) {
	const opts = _.extend({collection: new TabsCollection(tabs)}, options);
	return new TabTops(opts);
};
