const _ = require("underscore");
const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");
const SelectView = require("../../../utils/select/view");

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	template: require("./surgeon_summary.hbs"),
	templateContext() {
		let patient = this.model.getPatient();
		const ctx = {
			activePatient: patient
		};
		return ctx;
	},
	onRender() {
		if (!this.model) {
			return;
		}
	}
});
