const _ = require("underscore");
const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");

import FoldingView from "../../../components/folding_view";
import FormView from "../../../components/form/view";
import FieldsSelect from "../../../utils/entity-select/fields";
import ListsSelect from "../../../utils/entity-select/lists";

const BloodProductSubForm = FormView.extend({
	formFields: [
		{
			label: "Blood Type &amp; Cross Match",
			type: "text",
			field: "bloodTypeCrossMatch"
		}, {
			label: "Blood Type &amp; Screen",
			type: "text",
			field: "bloodTypeAndScreen"
		}, {
			label: "Autologous",
			type: "text",
			field: "autologous"
		}, {
			label: "Donor Directed",
			type: "text",
			field: "donorDirected"
		}, {
			label: "Units Required",
			type: "text",
			field: "unitsRequired"
		}
	],
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

const seFormFields = [
	{
		label: "Limited Quantity Items",
		type: "text",
		field: "limitedQuantityItems"
	}, {
		label: "Room Size",
		type: "text",
		field: "roomSize"
	}, {
		label: "Fixed Equipment",
		type: "text",
		field: "fixedEquipment"
	}, {
		label: "Environmental",
		type: "text",
		field: "environmental"
	}, {

		label: "Shields",
		type: "text",
		field: "shields"
	}, {

		label: "NSO Minimum Requirements",
		type: "text",
		field: "nsoMinimumReq"
	}, {
		label: "Other (Add Additional Fields)",
		type: "text",
		field: "seOther"
	}
];

const SpecificEquipmentSubForm = FormView.extend({
	formFields: seFormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});


const iiFormFields = [
	{
		label: "Locally Available",
		type: "yes-no",
		field: "locallyAvailable"
	}, {
		label: "Implant Provide Date (Required for Go/No Go)",
		type: "text",
		field: "implantProvideDate"
	}, {
		label: "Implant Ordered",
		type: "yes-no",
		field: "implantOrdered"
	}, {
		label: "Implant Received",
		type: "yes-no",
		field: "implantReceived"
	}, {
		label: "Customer Contact Phone Number",
		type: "text",
		field: "customerContactPhone"
	}, {
		label: "Customer Contact Email",
		type: "text",
		field: "customerContactEmail"
	}, {
		label: "Vendor Contact Date (Required for Go/No Go)",
		type: "text",
		field: "vendorContactDate"
	}, {
		label: "Vendor Provide Date (Required for Go/No Go)",
		type: "text",
		field: "vendorProvideDate"
	}, {
		label: "NSO Minimum Requirements",
		type: "text",
		field: "nsoMinimumReq"
	}, {
		label: "Vendor Availability",
		type: "text",
		field: "vendorAvailability"
	}

];

const ImplantInfoSubForm = FormView.extend({
	formFields: iiFormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

const scFormFields = [
	{
		label: "Planned Prosthetics/Implant",
		type: "text",
		field: "plannedProsthImplant"
	}, {
		type: "text",
		field: "pharmacyItems",
		label: "Pharmacy Items"
	}, {
		type: "text",
		field: "specialInstruments",
		label: "Special Instruments"
	}, {
		type: "text",
		field: "specialEquipment",
		label: "Special Equipment"
	}, {
		type: "text",
		field: "preoperativeLabs",
		label: "Preoperative Labs"
	}, {
		type: "text",
		field: "specialSupplies",
		label: "Special Supplies"
	}, {
		type: "text",
		field: "spdComments",
		label: "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Sterile Processing Service\">SPS</abbr> Comments"
	}, {
		type: "text",
		field: "preoperativeTests",
		label: "Preoperative Tests"
	}, {
		type: "yes-no",
		field: "reqPreopXray",
		label: "Request preop x-ray"
	}, {
		type: "yes-no",
		field: "reqFrozSect",
		label: "Request Frozen Section"
	}, {
		type: "yes-no",
		field: "reqPhoto",
		label: "Request intraop photo"
	}, {
		field: "intraoperativeXrays",
		label: "Intraop x-ray",
		type: "select",
		selSrc: FieldsSelect.IntraoperativeXrays
	}
];

const SpecialCaseForm = FormView.extend({
	formFields: scFormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	template: require("./special_case_panel.hbs"),
	regions: {
		bloodProductPanel: "#bloodProductInformationDiv",
		specificEquipmentPanel: "#specificEquipmentItemsDiv",
		implantInfoPanel: "#implantInfoItemsDiv",
		scForm: "#special-case-form"
	},
	onRender() {
		this.showChildView("scForm",
						new SpecialCaseForm({model: this.model}));

		this.showChildView("bloodProductPanel", new FoldingView({
			id: "CaseDataBloodProduct",
			title: "Blood Product Information",
			containedView: new BloodProductSubForm({
				model: this.model
			})
		}));

		this.showChildView("specificEquipmentPanel", new FoldingView({
			id: "CaseDataSpecificEquip",
			title: "Specific Equipment Items",
			containedView: new SpecificEquipmentSubForm({
				model: this.model
			})
		}));

		this.showChildView("implantInfoPanel", new FoldingView({
			id: "CaseDataImplantInfo",
			title: "Implant Information",
			containedView: new ImplantInfoSubForm({
				model: this.model
			})
		}));
	}
});
