import _ from "underscore";
import Backbone from "backbone";
import Marionette from "backbone.marionette";
import Radio from "backbone.radio";

import "bootstrap-select";

import authHeaders from "../../../../utils/authHeaders";
import SelectView from "../../../../utils/select/view";
import PeopleSelect from "../../../../utils/entity-select/people";

import FoldingView from "../../../../components/folding_view";
import FieldsSelect from "../../../../utils/entity-select/fields";
import ListsSelect from "../../../../utils/entity-select/lists";
import FormView from "../../../../components/form/view";
import CaseModel from "../../../../entities/case/model";
import CardiacAssessmentFields from "./cardiac_assessment_fields";
import NonCardiacAssessmentFields from "./non_cardiac_assessment_fields";

const CardiacSubForm = FormView.extend({
	formFields: CardiacAssessmentFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

const NonCardiacSubForm = FormView.extend({
	formFields: NonCardiacAssessmentFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	template: require("./template.hbs"),
	regions: {
		MycardiacPanel: "#CommonDataPanel",
		MynonCardiacPanel: "#NonCardiacDataPanel"
	},
	onRender() {
		this.showChildView("MynonCardiacPanel", new FoldingView({
			id: "NonCardiacPanelData",
			title: "Non Cardiac Risk Assessment",
			expand: true,
			containedView: new NonCardiacSubForm({
				model: this.model
			})
		}));

		this.showChildView("MycardiacPanel", new FoldingView({
			id: "CommonPanelData",
			title: "Cardiac Risk Assessment (Also fill in for Non Cardiac Assessment)",
			containedView: new CardiacSubForm({
				model: this.model
			})
		}));
	}
});