import FieldsSelect from "../../../../utils/entity-select/fields";

module.exports = [
	{
		"field": "general",
		"label": "General",
		"type": "yes-no",
		"comment": "Set"
	},
	{
		"field": "height",
		"label": "Height",
		"type": "text",
		"width": 2,
		"comment": "Free Text"
	},
	{
		"field": "weight",
		"label": "Weight",
		"type": "text",
		"width": 2,
		"comment": "Free Text"
	},

	{
		"field": "diabetesMellitusChronic",
		"label": "Diabetes Mellitus Chronic",
		"type": "select",
		"selSrc": FieldsSelect.diabetesMellitusChronic,
		"comment": "Set"
	},
	{
		"field": "diabetesMellitusPreopMgmt",
		"label": "Diabetes Mellitus Preop Mgmt.",
		"type": "select",
		"selSrc": FieldsSelect.diabetesMellitusPreopMgmt,
		"comment": "Set"
	},
	{
		"field": "tobaccoUse",
		"label": "Tobacco Use",
		"type": "select",
		"selSrc": FieldsSelect.tobaccoUse,
		"comment": "Set"
	},
	{
		"field": "tobaccoUseTimeframe",
		"label": "Tobacco Use Timeframe",
		"type": "select",
		"selSrc": FieldsSelect.tobaccoUseTimeframe,
		"comment": "Set"
	},
	{
		"field": "etohGTTwoDrinksPerDay",
		"label": "ETOH > 2 Drinks/Day",
		"type": "select",
		"selSrc": FieldsSelect.etohGTTwoDrinksPerDay,
		"comment": "Set"
	},
	{
		"field": "positiveDrugScreening",
		"label": "Positive Drug Screening",
		"type": "select",
		"selSrc": FieldsSelect.positiveDrugScreening,
		"comment": "Set"
	},
	{
		"field": "dyspnea",
		"label": "Dyspnea",
		"type": "select",
		"selSrc": FieldsSelect.dyspnea,
		"comment": "Set"
	},
	{
		"field": "preopSleepApnea",
		"label": "Preoperative Sleep Apnea",
		"type": "select",
		"selSrc": FieldsSelect.preopSleepApnea,
		"comment": "Set"
	},
	{
		"field": "dnrStatus",
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Do Not Resuscitate\">DNR</abbr> Status",
		"type": "select",
		"selSrc": FieldsSelect.dnrStatus,
		"comment": "Set"
	},
	{
		"field": "preopFunctHealthStatus",
		"label": "Preoperative Funct. Health Status",
		"type": "select",
		"selSrc": FieldsSelect.preopFunctHealthStatus,
		"comment": "Set"
	},
	{
		"field": "residence30DaysPreop",
		"label": "Residence 30 Days Preoperative",
		"type": "select",
		"selSrc": FieldsSelect.residence30DaysPreop,
		"comment": "Set"
	},
	{
		"field": "ambulationDevicePreop",
		"label": "Ambulation Device Preoperative",
		"type": "select",
		"selSrc": FieldsSelect.ambulationDevicePreop,
		"comment": "Set"
	},
	{
		"field": "homeless",
		"label": "Homeless",
		"type": "select",
		"selSrc": FieldsSelect.homeless,
		"comment": "Set"
	},
	{
		"field": "pulmonary",
		"label": "Pulmonary",
		"type": "yes-no",
		"comment": "Set"
	},
	{
		"field": "ventilatorDependent",
		"label": "Ventilator Dependent",
		"type": "select",
		"selSrc": FieldsSelect.ventilatorDependent,
		"comment": "Set"
	},
	{
		"field": "historyOfCOPD",
		"label": "History Of <abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Chronic Obstructive Pulmonary Disease\">COPD</abbr>",
		"type": "select",
		"selSrc": FieldsSelect.historyOfCOPD,
		"comment": "Set"
	},
	{
		"field": "currentPneumonia",
		"label": "Current Pneumonia",
		"type": "select",
		"selSrc": FieldsSelect.currentPneumonia,
		"comment": "Set"
	},
	{
		"field": "hepatobiliary",
		"label": "Hepatobiliary",
		"type": "yes-no",
		"comment": "Set"
	},
	{
		"field": "ascites",
		"label": "Ascites",
		"type": "select",
		"selSrc": FieldsSelect.ascites,
		"comment": "Set"
	},
	{
		"field": "gastrointestinal",
		"label": "Gastrointestinal",
		"type": "yes-no",
		"comment": "Set"
	},
	{
		"field": "esophagealVarices",
		"label": "Esophageal Varices",
		"type": "select",
		"selSrc": FieldsSelect.esophagealVarices,
		"comment": "Set"
	},
	{
		"field": "cardiac",
		"label": "Cardiac",
		"type": "yes-no",
		"comment": "Set"
	},
	{
		"field": "congestiveHeartFailurePreop",
		"label": "Congestive Heart Failure Preoperative",
		"type": "select",
		"selSrc": FieldsSelect.congestiveHeartFailurePreop,
		"comment": "Set"
	},
	{
		"field": "priorMI",
		"label": "Prior <abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Myocardial Infarction\">MI</abbr>",
		"type": "select",
		"selSrc": FieldsSelect.priorMI,
		"comment": "Set"
	},
	{
		"field": "pci",
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Percutaneous Coronary Intervention\">PCI</abbr>",
		"type": "select",
		"selSrc": FieldsSelect.pci,
		"comment": "Set"
	},
	{
		"field": "priorHearSurgery",
		"label": "Prior Heart Surgery",
		"type": "text",
		"comment": "Free Text"
	},
	{
		"field": "anginaSeverity",
		"label": "Angina Severity",
		"type": "select",
		"selSrc": FieldsSelect.anginaSeverity,
		"comment": "Set"
	},
	{
		"field": "anginaTimeframe",
		"label": "Angina Timeframe",
		"type": "select",
		"selSrc": FieldsSelect.anginaTimeframe,
		"comment": "Set"
	},


	{
		"field": "hypertension",
		"label": "Hypertension",
		"type": "select",
		"selSrc": FieldsSelect.hypertension,
		"comment": "Set"
	},
	{
		"field": "priorSurgSameOpField",
		"label": "Prior Surg Same Op Field",
		"type": "select",
		"selSrc": FieldsSelect.priorSurgSameOpField,
		"comment": "Set"
	},
	{
		"field": "hxRadRxPlannedSurgField",
		"label": "Hx Rad Rx Planned Surgical Field",
		"type": "select",
		"selSrc": FieldsSelect.hxRadRxPlannedSurgField,
		"comment": "Set"
	},
	{
		"field": "cvdRepair",
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Cardiovascular Disease\">CVD</abbr> Repair/Obstruction",
		"type": "select",
		"selSrc": FieldsSelect.cvdRepair,
		"comment": "Set"
	},
	{
		"field": "donorSerologyHIV",
		"label": "Donor Serology <abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Human Immunodeficiency Virus\">HIV</abbr>",
		"type": "select",
		"selSrc": FieldsSelect.donorSerologyHIV,
		"comment": "Set"
	},
	{
		"field": "peripheralArterialDisease",
		"label": "Peripheral Arterial Disease",
		"type": "select",
		"selSrc": FieldsSelect.peripheralArterialDisease,
		"comment": "Set"
	},
	{
		"field": "renalFailure",
		"label": "Acute Renal Failure Preoperative",
		"type": "select",
		"selSrc": FieldsSelect.renalFailure,
		"comment": "Set"
	},
	{
		"field": "vascular",
		"label": "Vascular",
		"type": "yes-no",
		"width": 2,
		"comment": "Set"
	},
	{
		"field": "renal",
		"label": "Renal",
		"type": "yes-no",
		"width": 2,
		"comment": "Set"
	},
	{
		"field": "onDialysis",
		"label": "Currently On Dialysis",
		"type": "yes-no",
		"width": 2,
		"comment": "Set"
	},
	{
		"field": "centralNervSystemIllness",
		"label": "Central Nervous System",
		"type": "yes-no",
		"width": 2,
		"comment": "Set"
	},
	{
		"field": "restPainGangrene",
		"label": "Rest Pain/Gangrene",
		"type": "yes-no",
		"width": 2,
		"comment": "Set"
	}
];