const _ = require("underscore");
const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");
const authHeaders = require("../../../utils/authHeaders");
const FormView = require("../../../components/form/view");

const pdpFormFields = [
	{
		label: "Patient Name",
		type: "read-only",
		field: "name"
	}, {
		label: "Gender",
		type: "read-only",
		field: "gender"
	}, {
		label: "Age",
		type: "read-only",
		field: "age"
	}, {
		label: "Date of Birth",
		type: "read-only",
		field: "dob"
	}, {
		label: "Provider",
		type: "read-only",
		field: "provider"
	}, {
		label: "SSN",
		type: "read-only",
		field: "ssn"
	}, {
		label: "Address",
		type: "read-only",
		field: "addrStreet1",
		width: 12
	}, {
		label: "City/State/Zip",
		type: "read-only",
		field: "addrCityStateZip",
		width: 12
	}, {
		label: "Residential Phone",
		type: "read-only",
		field: "resPhoneNum"
	}, {
		label: "Work Phone",
		type: "read-only",
		field: "workPhoneNum"
	}, {
		label: "Service Connected",
		type: "read-only",
		field: "scYesNo"
	}
];

module.exports = FormView.extend({
	formFields: pdpFormFields
});
