import _ from "underscore";
import Backbone from "backbone";
import Marionette from "backbone.marionette";
import Radio from "backbone.radio";

require("bootstrap-select");
import authHeaders from "../../../../utils/authHeaders";
import SelectView from "../../../../utils/select/view";
import FieldsSelect from "../../../../utils/entity-select/fields";
import ListsSelect from "../../../../utils/entity-select/lists";
import FieldCollections from "../../../../entities/fields/collections";
import ListCollections from "../../../../entities/lists/collections";
import FormView from "../../../../components/form/view";
const CaseModel = require("../../../../entities/case/model");


const FormFields = [
	{
		"label": "Time Patient in HOLD Area",
		"field": "TimePatInHold",
		"type": "time",
		"width": 6
	}
];

const Form = FormView.extend({
	formFields: FormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	regions: {
		Form: "#post-operation-form"
	},
	template: require("./post_operation.hbs"),
	onRender() {
		const aModel = this.model;
		this.showChildView("Form", new Form({model: this.model}));
		if (!this.model) {
			return;
		}
	}
});
