const Backbone = require("backbone");
const Marionette = require("backbone.marionette");
const _ = require("underscore");
const Radio = require("backbone.radio");
const API = require("../../../../api");
const authHeaders = require("../../../../utils/authHeaders");
const CPTCollection = require("../../../../entities/case/cpt/collection");
const CaseModel = require("../../../../entities/case/model");
const SpecialtiesCollection = require("../../../../entities/administration/specialty/collection");
const PersonCollection = require("../../../../entities/administration/person/collection");
const PatientModel = require("../../../../entities/patient/model");
const IndexView	= require("../../../../modules/index/view");
const CancelCaseView = require("../../cancel_case/view");
const CloseCaseView = require("../../close_case/view");
const TabView = require("../../../../components/tabs/view");
const CaseTabButtons = require("../case_tab_buttons");

const OperStart = require("./operation_start");
const Oper = require("./operation");
const PostOper = require("./post_operation");

let tabs = {
	"tab0": "Operation Start",
	"tab1": "Operation",
	"tab2": "Post Operation"
};

module.exports = Marionette.StateView.extend({
	className: "operations-tab-panel",
	regions: {
		tabRegion: "#subTabTops",
		buttonRegion: "#tabButtonsDiv",
		tabPanel: "#subTab"
	},

	defaultState: {
		showTabsPanel: true,
		showResultMessage: false,
		resultMessage: "",
		caseTypeValue: "",
		selectedTab: "tab0",
		currentIen: null
	},

	template: require("./operations_template.hbs"),

	childViewEvents: {
		"action": "formAction"
	},
	stateEvents: {
		"change": "render"
	},

	onChildviewTabSelected(tab) {
		this.state.set("selectedTab", tab);
	},

	getTabPanel(tab) {
		const model = this.model;

		switch (tab) {
		case "tab0": return new OperStart({ model });
		case "tab1": return new Oper({ model });
		case "tab2": return new PostOper({ model });
		default: throw new Error(`No panel for tab "${tab}"`);
		}
	},

	onRender() {
		const selectedTab = this.state.get("selectedTab");

		this.showChildView("tabRegion", new TabView({
			tabs,
			selected: selectedTab
		}));

		this.showChildView("tabPanel", this.getTabPanel(selectedTab));

		if (this.state.get("showTabsPanel")) {
			this.showChildView("buttonRegion", new CaseTabButtons({
				closeOrCancel: "cancel"
			}));
		}
	},
	formAction(action) {/** Pull from case_list/view.js **/ }
});
