import _ from "underscore";
import Backbone from "backbone";
import Marionette from "backbone.marionette";
import Radio from "backbone.radio";

require("bootstrap-select");
import authHeaders from "../../../../utils/authHeaders";
import SelectView from "../../../../utils/select/view";
import PeopleSelect from "../../../../utils/entity-select/people";

import FieldsSelect from "../../../../utils/entity-select/fields";
// import FieldCollections from "../../../../entities/fields/collections";

import ListsSelect from "../../../../utils/entity-select/lists";
// import ListCollections from "../../../../entities/lists/collections";

import FormView from "../../../../components/form/view";
const CaseModel = require("../../../../entities/case/model");


const FormFields = [
	{
		"label": "Surgical Specialty",
		"type": "select",
		"selSrc": ListsSelect.Specialty,
		"valueKey": "id",
		"labelKey": "name",
		"field": "surgerySpecialty"
	},
	{
		"label": "Planned Postop Care",
		"field": "plannedPostopCare",
		"type": "select",
		"selSrc": ListsSelect.PostopCare,
		"width": 6
	},
	{
		"label": "Case Schedule Type",
		"field": "caseScheduleType",
		"type": "select",
		"selSrc": FieldsSelect.CaseScheduleType,
		"width": 6
	},
	{
		"label": "Req Anesthesia Technique",
		"field": "anesthesiaTechnique",
		"type": "select",
		"selSrc": FieldsSelect.AnesthesiaTechnique,
		"valueKey": "code",
		"labelKey": "value",
		"width": 6
	},
	{
		"label": "Patient education/ assessment",
		"field": "patEdu",
		"type": "yes-no-na-unk",
		"width": 6
	},
	{
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"American Society of Anesthesiology\">ASA</abbr> Class",
		"field": "asaClass",
		"type": "select",
		"selSrc": ListsSelect.AsaClass,
		"valueKey": "asaClass",
		"labelKey": "physcialStatus",
		"width": 6
	},
	{
		"label": "Preop Mood",
		"field": "preopMood",
		"type": "text",
		"width": 6
	},
	{
		"label": "Preop Conscious",
		"field": "preopConsc",
		"type": "text",
		"width": 6
	},
	{
		"label": "Preop Skin Integrity",
		"field": "preopSkin",
		"type": "text",
		"width": 6
	},
	{
		"label": "Transport To or By",
		"field": "xPortBy",
		"type": "text",
		"width": 6
	},
	{
		"label": "Hair Removal By",
		"field": "HairRemovalBy",
		"type": "select",
		"selSrc": PeopleSelect,
		"valueKey": "id",
		"labelKey": "name",
		"width": 6
	},
	{
		"label": "Hair Removal Method",
		"field": "hrMethod",
		"type": "text",
		"width": 6
	},
	{
		"label": "Poly Catheter Inserted By",
		"field": "PolyCatheterInsertedBy",
		"type": "select",
		"selSrc": PeopleSelect,
		"valueKey": "id",
		"labelKey": "name",
		"width": 6
	},
	{
		"label": "Skin Prepped By",
		"field": "skinPreppedBy",
		"type": "select",
		"selSrc": PeopleSelect,
		"valueKey": "id",
		"labelKey": "name",
		"width": 6
	},
	{
		"label": "Skin prep Agents",
		"field": "skinPrepAgents",
		"type": "text",
		"width": 6
	},
	{
		"label": "Surgery Position",
		"field": "surgeryPosition",
		"type": "select",
		"selSrc": ListsSelect.Positions,
		"valueKey": "id",
		"labelKey": "name",
		"width": 6
	},
	{
		label: "Laterality of Procedure",
		field: "procedureLaterality",
		type: "select",
		selSrc: FieldsSelect.ProcedureLaterality
	},
	{
		"label": "Restr and Position AIDS",
		"field": "restrPosAIDS",
		"type": "text",
		"width": 6
	},
	{
		"label": "Electroground Position ",
		"field": "eGroundPos",
		"type": "text",
		"width": 6
	}
];

const Form = FormView.extend({
	formFields: FormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	regions: {
		Form: "#operation-start-form"
	},
	template: require("./operation_start.hbs"),
	onRender() {
		const aModel = this.model;
		this.showChildView("Form", new Form({model: this.model}));
		if (!this.model) {
			return;
		}
	}
});
