import _ from "underscore";
import Backbone from "backbone";
import Marionette from "backbone.marionette";
import Radio from "backbone.radio";

require("bootstrap-select");
import authHeaders from "../../../../utils/authHeaders";
import SelectView from "../../../../utils/select/view";
import FieldsSelect from "../../../../utils/entity-select/fields";
import ListsSelect from "../../../../utils/entity-select/lists";
import FieldCollections from "../../../../entities/fields/collections";
import ListCollections from "../../../../entities/lists/collections";
import FormView from "../../../../components/form/view";
const CaseModel = require("../../../../entities/case/model");


const FormFields = [
	{
		"label": "Time Patient in Hold Area",
		"field": "TimePatInHold",
		"type": "time",
		"width": 3
	},
	{
		"label": "Operation Start",
		"field": "OperStart",
		"type": "time",
		"width": 3
	},
	{
		"label": "Time Patient in OR",
		"field": "TimePatInOR",
		"type": "time",
		"width": 3
	},
	{
		"label": "Anesthesia Care",
		"field": "AnesCare",
		"type": "time",
		"width": 3
	},

	{
		"label": "Specimens",
		"field": "Specimens",
		"type": "text-area",
		"width": 12
	},
	{
		"label": "Cultures",
		"field": "Cultures",
		"type": "text-area",
		"width": 12
	},
	{
		"label": "Thermal Unit",
		"field": "ThermalUnit",
		"type": "text-area",
		"width": 12
	},
	{
		"label": "Electrocautery Unit",
		"field": "ElecCautUnit",
		"type": "text",
		"width": 6
	},
	{
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Electrosurgical Unit\">ESU</abbr> Coagulation Range",
		"field": "ESUCoagRange",
		"type": "text",
		"width": 6
	},
	{
		"label": "<abbr data-placement=\"bottom\" placement=\"bottom\" data-toggle=\"tooltip\" title=\"Electrosurgical Unit\">ESU</abbr> Cutting Range",
		"field": "ESUCutRange",
		"type": "text",
		"width": 6
	},
	{
		"label": "Time Tourniquet Applied",
		"field": "TimeTourniqApplied",
		"type": "time",
		"width": 3
	},
	{
		"label": "Prosthesis Installed",
		"field": "ProsthInstall",
		"type": "text-area",
		"width": 12
	},
	{
		"label": "Replacement Fluid Type",
		"field": "RplcFluidType",
		"type": "text-area",
		"width": 6
	},
	{
		"label": "Irrigation",
		"field": "Irrigation",
		"type": "text-area",
		"width": 6
	},
	{
		"label": "Medications",
		"field": "Meds",
		"type": "text-area",
		"width": 6
	},
	{
		"label": "Possible Item Retention",
		"field": "PossItemReten",
		"type": "yes-no",
		"width": 6
	}
];

const Form = FormView.extend({
	formFields: FormFields,
	className: "case-tab-panel",
	onRender() {
		if (!this.model) {
			return;
		}
	}
});

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	regions: {
		Form: "#operation-form"
	},
	template: require("./operation.hbs"),
	onRender() {
		this.showChildView("Form", new Form({model: this.model}));
		if (!this.model) {
			return;
		}
	}
});
