import _ from "underscore";
import Backbone from "backbone";
import Marionette from "backbone.marionette";
import Radio from "backbone.radio";
import authHeaders from "../../../utils/authHeaders";

require("bootstrap-select");

import SelectView from "../../../utils/select/view";
import FieldCollections from "../../../entities/fields/collections";
import ListCollections from "../../../entities/lists/collections";
import FormView from "../../../components/form/view";

import FieldsSelect from "../../../utils/entity-select/fields";
import ListsSelect from "../../../utils/entity-select/lists";
import CaseSelect from "../../../utils/entity-select/case";

const intraFormFields = [
	{
		label: "Planned OR Room",
		field: "orRoom",
		type: "select",
		selSrc: ListsSelect.ORRooms
	}, {
		label: "OR Room performed",
		field: "orRoomPerformed",
		type: "select",
		selSrc: ListsSelect.ORRooms
	}, {
		label: "Surgery Position",
		type: "select",
		field: "surgeryPosition",
		selSrc: ListsSelect.Positions
	}, {
		label: "Requested Anesthesia Technique",
		field: "reqAneTechnique",
		type: "select",
		selSrc: FieldsSelect.AnesthesiaTechnique
	}, {
		label: "Principal Anesthetist",
		field: "princAnesthetist",
		type: "select",
		selSrc: ListsSelect.People
	}, {
		label: "Anesthesia Supervisor",
		field: "anesthesiologistSupvr",
		type: "select",
		selSrc: ListsSelect.People
	}, {
		label: "Preoperative Infection",
		type: "select",
		field: "preoperativeInfection",
		selSrc: FieldsSelect.PreOpInfection
	}, {
		label: "Planned Postop Care",
		type: "select",
		field: "plannedPostopCare",
		selSrc: ListsSelect.PostopCare
	}, {
		label: "Room Type",
		type: "select",
		field: "roomType",
		selSrc: ListsSelect.Specialty
	}, {
		label: "Multiple Team Case",
		type: "select",
		field: "concurrentCase",
		selSrc: CaseSelect,
		onSet(v, m) {
			console.log("onSet:", v, m);
			let caseId = m.id;
			let url = `/v1/cases/${caseId}/concurrentCase/${v}`;

			let options = _.extend(authHeaders(), {
				method: "PUT",
				success: () => {
					Radio.request("root", "dialog", {
						type: "info",
						title: "Set Multiple Team Case Success",
						message: "Saved added multiple team case."
					});
				},
				error: () => {
					Radio.request("root", "dialog", {
						type: "error",
						title: "Set Multiple Team Case Error",
						message: "Please try again later."
					});
				}
			});
			$.ajax(url, options);

			return v;
		}
		// fetchOptions will be added below.
	}
];

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	initialize() {
		let mtc = _.extend(_.last(intraFormFields));
		mtc.fetchOptions = { patientId: this.model.get("patient")};
		this.intraFormFields = _.initial(intraFormFields).concat(mtc);
		console.log("iop mtc:", mtc);
		this.IntraoperativeForm = FormView.extend({
			formFields: this.intraFormFields,
			className: "case-tab-panel",
			onRender() {
				if (!this.model) {
					return;
				}
			}
		});
	},
	regions: {
		intraopForm: "#intraop-form"
	},
	template: require("./intraop_panel.hbs"),
	onRender() {
		this.showChildView("intraopForm",
						new this.IntraoperativeForm({model: this.model}));

		if (!this.model) {
			return;
		}

	}
});
