const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");

module.exports = Marionette.View.extend({
	template: require("./folding_view.hbs"),
	tagName: "fieldset",
	className: "accordian-group",
	ui: {
		titleHeader: ".folding-title",
		containedFields: ".contained-fields"
	},
	onRender() {
		this.getUI("titleHeader").attr("data-target", "#" + this.id + "Inside")
			.prepend(this.getOption("title"));
		const data = this.serializeData();
		const contents = this.getOption("contents");
		this.getUI("containedFields").html(contents(data))
			.attr("id", this.id + "Inside");
	}
});
